package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import jakarta.annotation.Generated;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DFSPublicKeyServiceImplRuntimeDelegatable extends DFSPublicKeyServiceImpl {
    private final DFSPublicKeyServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DFSPublicKeyServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            KeyStoreCache keystoreCache, BucketAccessService bucketAccessService,
            ProfileRetrievalService profiles, StorageReadService readService, GsonSerde serde) {
        super(keystoreCache, bucketAccessService, profiles, readService, serde);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keystoreCache, bucketAccessService, profiles, readService, serde);
        delegate = context != null ? context.findOverride(DFSPublicKeyServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public PublicKeyIDWithPublicKey publicKey(UserID forUser) {
        if (null == delegate) {
            return super.publicKey(forUser);
        } else {
            return delegate.publicKey(forUser);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DFSPublicKeyServiceImpl> ctorCaptor) {
        context.override(DFSPublicKeyServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final KeyStoreCache keystoreCache;

        private final BucketAccessService bucketAccessService;

        private final ProfileRetrievalService profiles;

        private final StorageReadService readService;

        private final GsonSerde serde;

        private ArgumentsCaptor(KeyStoreCache keystoreCache,
                BucketAccessService bucketAccessService, ProfileRetrievalService profiles,
                StorageReadService readService, GsonSerde serde) {
            this.keystoreCache = keystoreCache;
            this.bucketAccessService = bucketAccessService;
            this.profiles = profiles;
            this.readService = readService;
            this.serde = serde;
        }

        public KeyStoreCache getKeystoreCache() {
            return keystoreCache;
        }

        public BucketAccessService getBucketAccessService() {
            return bucketAccessService;
        }

        public ProfileRetrievalService getProfiles() {
            return profiles;
        }

        public StorageReadService getReadService() {
            return readService;
        }

        public GsonSerde getSerde() {
            return serde;
        }
    }
}
