/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.resource;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.resource.ResourceResolverImpl;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class ResourceResolverImplRuntimeDelegatable
extends ResourceResolverImpl {
    private final ResourceResolverImpl delegate;

    @Inject
    public ResourceResolverImplRuntimeDelegatable(@Nullable OverridesRegistry context, ProfileRetrievalService profile, BucketAccessService bucketAccessService) {
        super(profile, bucketAccessService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(profile, bucketAccessService);
        this.delegate = context != null ? (ResourceResolverImpl)context.findOverride(ResourceResolverImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public AbsoluteLocation<PublicResource> resolveRelativeToPublicInbox(UserID userID, PublicResource resource) {
        if (null == this.delegate) {
            return super.resolveRelativeToPublicInbox(userID, resource);
        }
        return this.delegate.resolveRelativeToPublicInbox(userID, resource);
    }

    @Override
    public AbsoluteLocation<PrivateResource> resolveRelativeToPrivateInbox(UserIDAuth userID, PrivateResource resource) {
        if (null == this.delegate) {
            return super.resolveRelativeToPrivateInbox(userID, resource);
        }
        return this.delegate.resolveRelativeToPrivateInbox(userID, resource);
    }

    @Override
    public AbsoluteLocation<PrivateResource> resolveRelativeToPrivate(UserIDAuth userID, PrivateResource resource, StorageIdentifier identifier) {
        if (null == this.delegate) {
            return super.resolveRelativeToPrivate(userID, resource, identifier);
        }
        return this.delegate.resolveRelativeToPrivate(userID, resource, identifier);
    }

    @Override
    public <T extends ResourceLocation<T>> boolean isAbsolute(T resource) {
        if (null == this.delegate) {
            return super.isAbsolute(resource);
        }
        return this.delegate.isAbsolute(resource);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, ResourceResolverImpl> ctorCaptor) {
        context.override(ResourceResolverImpl.class, args -> (ResourceResolverImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final ProfileRetrievalService profile;
        private final BucketAccessService bucketAccessService;

        private ArgumentsCaptor(ProfileRetrievalService profile, BucketAccessService bucketAccessService) {
            this.profile = profile;
            this.bucketAccessService = bucketAccessService;
        }

        public ProfileRetrievalService getProfile() {
            return this.profile;
        }

        public BucketAccessService getBucketAccessService() {
            return this.bucketAccessService;
        }
    }
}

