/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImpl;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class ProfileRetrievalServiceImplRuntimeDelegatable
extends ProfileRetrievalServiceImpl {
    private final ProfileRetrievalServiceImpl delegate;

    @Inject
    public ProfileRetrievalServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context, DFSConfig dfsConfig, StorageReadService readService, StorageCheckService checkService, BucketAccessService access, GsonSerde serde, UserProfileCache userProfileCache) {
        super(dfsConfig, readService, checkService, access, serde, userProfileCache);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(dfsConfig, readService, checkService, access, serde, userProfileCache);
        this.delegate = context != null ? (ProfileRetrievalServiceImpl)context.findOverride(ProfileRetrievalServiceImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public UserPublicProfile publicProfile(UserID ofUser) {
        if (null == this.delegate) {
            return super.publicProfile(ofUser);
        }
        return this.delegate.publicProfile(ofUser);
    }

    @Override
    public UserPrivateProfile privateProfile(UserIDAuth ofUser) {
        if (null == this.delegate) {
            return super.privateProfile(ofUser);
        }
        return this.delegate.privateProfile(ofUser);
    }

    @Override
    public boolean userExists(UserID ofUser) {
        if (null == this.delegate) {
            return super.userExists(ofUser);
        }
        return this.delegate.userExists(ofUser);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, ProfileRetrievalServiceImpl> ctorCaptor) {
        context.override(ProfileRetrievalServiceImpl.class, args -> (ProfileRetrievalServiceImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final DFSConfig dfsConfig;
        private final StorageReadService readService;
        private final StorageCheckService checkService;
        private final BucketAccessService access;
        private final GsonSerde serde;
        private final UserProfileCache userProfileCache;

        private ArgumentsCaptor(DFSConfig dfsConfig, StorageReadService readService, StorageCheckService checkService, BucketAccessService access, GsonSerde serde, UserProfileCache userProfileCache) {
            this.dfsConfig = dfsConfig;
            this.readService = readService;
            this.checkService = checkService;
            this.access = access;
            this.serde = serde;
            this.userProfileCache = userProfileCache;
        }

        public DFSConfig getDfsConfig() {
            return this.dfsConfig;
        }

        public StorageReadService getReadService() {
            return this.readService;
        }

        public StorageCheckService getCheckService() {
            return this.checkService;
        }

        public BucketAccessService getAccess() {
            return this.access;
        }

        public GsonSerde getSerde() {
            return this.serde;
        }

        public UserProfileCache getUserProfileCache() {
            return this.userProfileCache;
        }
    }
}

