/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPublicKeyServiceImpl;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class DFSPublicKeyServiceImplRuntimeDelegatable
extends DFSPublicKeyServiceImpl {
    private final DFSPublicKeyServiceImpl delegate;

    @Inject
    public DFSPublicKeyServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context, KeyStoreCache keystoreCache, BucketAccessService bucketAccessService, ProfileRetrievalService profiles, StorageReadService readService, GsonSerde serde) {
        super(keystoreCache, bucketAccessService, profiles, readService, serde);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keystoreCache, bucketAccessService, profiles, readService, serde);
        this.delegate = context != null ? (DFSPublicKeyServiceImpl)context.findOverride(DFSPublicKeyServiceImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public PublicKeyIDWithPublicKey publicKey(UserID forUser) {
        if (null == this.delegate) {
            return super.publicKey(forUser);
        }
        return this.delegate.publicKey(forUser);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, DFSPublicKeyServiceImpl> ctorCaptor) {
        context.override(DFSPublicKeyServiceImpl.class, args -> (DFSPublicKeyServiceImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final KeyStoreCache keystoreCache;
        private final BucketAccessService bucketAccessService;
        private final ProfileRetrievalService profiles;
        private final StorageReadService readService;
        private final GsonSerde serde;

        private ArgumentsCaptor(KeyStoreCache keystoreCache, BucketAccessService bucketAccessService, ProfileRetrievalService profiles, StorageReadService readService, GsonSerde serde) {
            this.keystoreCache = keystoreCache;
            this.bucketAccessService = bucketAccessService;
            this.profiles = profiles;
            this.readService = readService;
            this.serde = serde;
        }

        public KeyStoreCache getKeystoreCache() {
            return this.keystoreCache;
        }

        public BucketAccessService getBucketAccessService() {
            return this.bucketAccessService;
        }

        public ProfileRetrievalService getProfiles() {
            return this.profiles;
        }

        public StorageReadService getReadService() {
            return this.readService;
        }

        public GsonSerde getSerde() {
            return this.serde;
        }
    }
}

