/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.dfs;

import dagger.Lazy;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.types.StorageCredentials;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class RegexAccessServiceWithStorageCredentialsImpl
implements BucketAccessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegexAccessServiceWithStorageCredentialsImpl.class);
    private final Lazy<StorageKeyStoreOperations> storageKeyStoreOperations;

    @Inject
    public RegexAccessServiceWithStorageCredentialsImpl(Lazy<StorageKeyStoreOperations> storageKeyStoreOperations) {
        this.storageKeyStoreOperations = storageKeyStoreOperations;
    }

    public AbsoluteLocation<PrivateResource> privateAccessFor(UserIDAuth user, PrivateResource resource) {
        log.debug("get private access for user {} and bucket {}", (Object)user, (Object)resource);
        Optional<StorageIdentifier> storageAccess = this.getStorageAccessCredentials(user, resource);
        if (!storageAccess.isPresent()) {
            ((StorageKeyStoreOperations)this.storageKeyStoreOperations.get()).invalidateCache(user);
            storageAccess = this.getStorageAccessCredentials(user, resource);
            if (!storageAccess.isPresent()) {
                return new AbsoluteLocation((ResourceLocation)resource);
            }
        }
        StorageCredentials creds = ((StorageKeyStoreOperations)this.storageKeyStoreOperations.get()).getStorageCredentials(user, storageAccess.get());
        return new AbsoluteLocation((ResourceLocation)resource.withAuthority(creds.getUsername(), creds.getPassword()));
    }

    public AbsoluteLocation<PublicResource> publicAccessFor(UserID user, PublicResource resource) {
        log.debug("get public access for user {} and bucket {}", (Object)user, (Object)resource.location());
        return new AbsoluteLocation((ResourceLocation)resource);
    }

    public AbsoluteLocation withSystemAccess(AbsoluteLocation resource) {
        log.debug("get system access for {}", (Object)resource.location());
        return new AbsoluteLocation((ResourceLocation)resource);
    }

    private Optional<StorageIdentifier> getStorageAccessCredentials(UserIDAuth user, PrivateResource resource) {
        String uri = resource.location().asString();
        Set aliases = ((StorageKeyStoreOperations)this.storageKeyStoreOperations.get()).readAliases(user);
        Optional<StorageIdentifier> directMatch = aliases.stream().filter(it -> uri.matches(it.getId())).findFirst();
        return directMatch.isPresent() ? directMatch : aliases.stream().filter(it -> StorageIdentifier.DEFAULT.getId().equals(it.getId())).findFirst();
    }
}

