/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileStorageCredentialsService;
import de.adorsys.datasafe.directory.api.types.StorageCredentials;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.util.Set;
import javax.inject.Inject;

@RuntimeDelegate
public class ProfileStorageCredentialsServiceImpl
implements ProfileStorageCredentialsService {
    private final StorageKeyStoreOperations keyStoreOper;
    private final PrivateKeyService privateKeyService;

    @Inject
    public ProfileStorageCredentialsServiceImpl(StorageKeyStoreOperations keyStoreOper, PrivateKeyService privateKeyService) {
        this.keyStoreOper = keyStoreOper;
        this.privateKeyService = privateKeyService;
    }

    public Set<StorageIdentifier> listRegisteredStorageCredentials(UserIDAuth user) {
        this.validateKeystoreAccess(user);
        return this.keyStoreOper.readAliases(user);
    }

    public void registerStorageCredentials(UserIDAuth user, StorageIdentifier storageId, StorageCredentials credentials) {
        this.validateKeystoreAccess(user);
        this.keyStoreOper.addStorageCredentials(user, storageId, credentials);
    }

    public void deregisterStorageCredentials(UserIDAuth user, StorageIdentifier storageId) {
        this.validateKeystoreAccess(user);
        this.keyStoreOper.removeStorageCredentials(user, storageId);
    }

    private void validateKeystoreAccess(UserIDAuth user) {
        this.privateKeyService.validateUserHasAccessOrThrow(user);
    }
}

