/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.io.InputStream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class ProfileRetrievalServiceImpl
implements ProfileRetrievalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileRetrievalServiceImpl.class);
    private final DFSConfig dfsConfig;
    private final StorageReadService readService;
    private final StorageCheckService checkService;
    private final BucketAccessService access;
    private final GsonSerde serde;
    private final UserProfileCache userProfileCache;

    @Inject
    public ProfileRetrievalServiceImpl(DFSConfig dfsConfig, StorageReadService readService, StorageCheckService checkService, BucketAccessService access, GsonSerde serde, UserProfileCache userProfileCache) {
        this.dfsConfig = dfsConfig;
        this.readService = readService;
        this.checkService = checkService;
        this.access = access;
        this.serde = serde;
        this.userProfileCache = userProfileCache;
    }

    public UserPublicProfile publicProfile(UserID ofUser) {
        UserPublicProfile userPublicProfile = this.userProfileCache.getPublicProfile().computeIfAbsent(ofUser, id -> this.readProfile(this.dfsConfig.publicProfile(ofUser), UserPublicProfile.class));
        log.debug("get public profile {} for user {}", (Object)userPublicProfile, (Object)ofUser);
        return userPublicProfile;
    }

    public UserPrivateProfile privateProfile(UserIDAuth ofUser) {
        UserPrivateProfile userPrivateProfile = this.userProfileCache.getPrivateProfile().computeIfAbsent(ofUser.getUserID(), id -> this.readProfile(this.dfsConfig.privateProfile(ofUser.getUserID()), UserPrivateProfile.class));
        log.debug("get private profile {} for user {}", (Object)userPrivateProfile, (Object)ofUser);
        return userPrivateProfile;
    }

    public boolean userExists(UserID ofUser) {
        return this.checkService.objectExists(this.access.withSystemAccess(this.dfsConfig.privateProfile(ofUser))) && this.checkService.objectExists(this.access.withSystemAccess(this.dfsConfig.publicProfile(ofUser)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readProfile(AbsoluteLocation resource, Class<T> clazz) {
        try (InputStream is = this.readService.read(this.access.withSystemAccess(resource));){
            log.debug("read profile {}", (Object)resource.location());
            T t = this.serde.fromJson(new String(ByteStreams.toByteArray((InputStream)is)), clazz);
            return t;
        }
    }
}

