/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import java.security.Key;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserKeyStoreCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserKeyStoreCache.class);
    private final Map<UserID, KeyStore> map;

    public KeyStore computeIfAbsent(UserIDAuth userIDAuth, Function<? super UserID, ? extends KeyStore> mappingFunction) {
        if (this.map.containsKey(userIDAuth.getUserID())) {
            return this.map.get(userIDAuth.getUserID());
        }
        KeyStore keyStore = mappingFunction.apply((UserID)userIDAuth.getUserID());
        if (!"UBER".equals(keyStore.getType())) {
            keyStore = this.convertKeyStoreToUberKeyStore(userIDAuth, keyStore);
        }
        this.map.put(userIDAuth.getUserID(), keyStore);
        return keyStore;
    }

    private KeyStore convertKeyStoreToUberKeyStore(UserIDAuth currentCredentials, KeyStore current) {
        log.debug("the keystore for user {} is of type {} and will be converted to uber in cache", (Object)currentCredentials.getUserID(), (Object)current.getType());
        KeyStore newKeystore = KeyStore.getInstance("UBER");
        newKeystore.load(null, null);
        Enumeration<String> aliases = current.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Key currentKey = current.getKey(alias, currentCredentials.getReadKeyPassword().getValue());
            newKeystore.setKeyEntry(alias, currentKey, currentCredentials.getReadKeyPassword().getValue(), current.getCertificateChain(alias));
        }
        return newKeystore;
    }

    @Generated
    public UserKeyStoreCache(Map<UserID, KeyStore> map) {
        this.map = map;
    }

    @Generated
    public int size() {
        return this.map.size();
    }

    @Generated
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Generated
    public boolean containsKey(Object arg0) {
        return this.map.containsKey(arg0);
    }

    @Generated
    public boolean containsValue(Object arg0) {
        return this.map.containsValue(arg0);
    }

    @Generated
    public KeyStore get(Object arg0) {
        return this.map.get(arg0);
    }

    @Generated
    public KeyStore put(UserID arg0, KeyStore arg1) {
        return this.map.put(arg0, arg1);
    }

    @Generated
    public KeyStore remove(Object arg0) {
        return this.map.remove(arg0);
    }

    @Generated
    public void putAll(Map<? extends UserID, ? extends KeyStore> arg0) {
        this.map.putAll(arg0);
    }

    @Generated
    public void clear() {
        this.map.clear();
    }

    @Generated
    public Set<UserID> keySet() {
        return this.map.keySet();
    }

    @Generated
    public Collection<KeyStore> values() {
        return this.map.values();
    }

    @Generated
    public Set<Map.Entry<UserID, KeyStore>> entrySet() {
        return this.map.entrySet();
    }

    @Generated
    public KeyStore getOrDefault(Object arg0, KeyStore arg1) {
        return this.map.getOrDefault(arg0, arg1);
    }

    @Generated
    public void forEach(BiConsumer<? super UserID, ? super KeyStore> arg0) {
        this.map.forEach(arg0);
    }

    @Generated
    public void replaceAll(BiFunction<? super UserID, ? super KeyStore, ? extends KeyStore> arg0) {
        this.map.replaceAll(arg0);
    }

    @Generated
    public KeyStore putIfAbsent(UserID arg0, KeyStore arg1) {
        return this.map.putIfAbsent(arg0, arg1);
    }

    @Generated
    public boolean remove(Object arg0, Object arg1) {
        return this.map.remove(arg0, arg1);
    }

    @Generated
    public boolean replace(UserID arg0, KeyStore arg1, KeyStore arg2) {
        return this.map.replace(arg0, arg1, arg2);
    }

    @Generated
    public KeyStore replace(UserID arg0, KeyStore arg1) {
        return this.map.replace(arg0, arg1);
    }

    @Generated
    public KeyStore computeIfPresent(UserID arg0, BiFunction<? super UserID, ? super KeyStore, ? extends KeyStore> arg1) {
        return this.map.computeIfPresent(arg0, arg1);
    }

    @Generated
    public KeyStore compute(UserID arg0, BiFunction<? super UserID, ? super KeyStore, ? extends KeyStore> arg1) {
        return this.map.compute(arg0, arg1);
    }

    @Generated
    public KeyStore merge(UserID arg0, KeyStore arg1, BiFunction<? super KeyStore, ? super KeyStore, ? extends KeyStore> arg2) {
        return this.map.merge(arg0, arg1, arg2);
    }

    private static interface ExcludeComputeIfAbsent<K, V> {
        public KeyStore computeIfAbsent(UserID var1, Function<? super UserID, ? extends KeyStore> var2);
    }
}

