/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.profile.keys.DocumentKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.AuthPathEncryptionSecretKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class DFSPrivateKeyServiceImpl
implements PrivateKeyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DFSPrivateKeyServiceImpl.class);
    private final DocumentKeyStoreOperations keyStoreOper;

    @Inject
    public DFSPrivateKeyServiceImpl(DocumentKeyStoreOperations keyStoreOper) {
        this.keyStoreOper = keyStoreOper;
    }

    public AuthPathEncryptionSecretKey pathEncryptionSecretKey(UserIDAuth forUser) {
        Set aliases = this.keyStoreOper.readAliases(forUser);
        SecretKeyIDWithKey secretPathKeyId = this.keyByPrefix(forUser, aliases, "PATH_SECRET");
        SecretKeyIDWithKey secretPathCtrKeyId = this.keyByPrefix(forUser, aliases, "PATH_CTR_SECRET_");
        return new AuthPathEncryptionSecretKey(secretPathKeyId, secretPathCtrKeyId);
    }

    public SecretKeyIDWithKey documentEncryptionSecretKey(UserIDAuth forUser) {
        return this.keyByPrefix(forUser, "PRIVATE_SECRET");
    }

    public void validateUserHasAccessOrThrow(UserIDAuth forUser) {
        try {
            this.keyByPrefix(forUser, "PRIVATE_SECRET");
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof KeyStoreException || ex.getCause() instanceof UnrecoverableKeyException || ex.getCause() instanceof BadPaddingException) {
                throw ex.getCause();
            }
            log.debug("Caught exception while validating keystore access", ex.getCause());
        }
    }

    public Map<String, Key> keysByIds(UserIDAuth forUser, Set<String> keyIds) {
        Set aliases = this.keyStoreOper.readAliases(forUser);
        return keyIds.stream().filter(aliases::contains).collect(Collectors.toMap(keyId -> keyId, keyId -> this.keyStoreOper.getKey(forUser, keyId)));
    }

    protected SecretKeyIDWithKey keyByPrefix(UserIDAuth forUser, String prefix) {
        return this.keyByPrefix(forUser, this.keyStoreOper.readAliases(forUser), prefix);
    }

    protected SecretKeyIDWithKey keyByPrefix(UserIDAuth forUser, Collection<String> aliases, String prefix) {
        KeyID key = aliases.stream().filter(it -> it.startsWith(prefix)).map(KeyID::new).findFirst().orElseThrow(() -> new IllegalArgumentException("No key with prefix: " + prefix));
        return new SecretKeyIDWithKey(key, (SecretKey)this.keyStoreOper.getKey(forUser, key.getValue()));
    }
}

