/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStoreService;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class ProfileStoreServiceRuntimeDelegatable
extends ProfileStoreService {
    private final ProfileStoreService delegate;

    @Inject
    public ProfileStoreServiceRuntimeDelegatable(@Nullable OverridesRegistry context, GsonSerde serde, UserProfileCache profileCache, DFSConfig dfsConfig, BucketAccessService access, StorageWriteService writeService) {
        super(serde, profileCache, dfsConfig, access, writeService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(serde, profileCache, dfsConfig, access, writeService);
        this.delegate = context != null ? (ProfileStoreService)context.findOverride(ProfileStoreService.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public void registerPrivate(UserID id, UserPrivateProfile profile) {
        if (null == this.delegate) {
            super.registerPrivate(id, profile);
        } else {
            this.delegate.registerPrivate(id, profile);
        }
    }

    @Override
    public void registerPublic(UserID id, UserPublicProfile profile) {
        if (null == this.delegate) {
            super.registerPublic(id, profile);
        } else {
            this.delegate.registerPublic(id, profile);
        }
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, ProfileStoreService> ctorCaptor) {
        context.override(ProfileStoreService.class, args -> (ProfileStoreService)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final GsonSerde serde;
        private final UserProfileCache profileCache;
        private final DFSConfig dfsConfig;
        private final BucketAccessService access;
        private final StorageWriteService writeService;

        private ArgumentsCaptor(GsonSerde serde, UserProfileCache profileCache, DFSConfig dfsConfig, BucketAccessService access, StorageWriteService writeService) {
            this.serde = serde;
            this.profileCache = profileCache;
            this.dfsConfig = dfsConfig;
            this.access = access;
            this.writeService = writeService;
        }

        public GsonSerde getSerde() {
            return this.serde;
        }

        public UserProfileCache getProfileCache() {
            return this.profileCache;
        }

        public DFSConfig getDfsConfig() {
            return this.dfsConfig;
        }

        public BucketAccessService getAccess() {
            return this.access;
        }

        public StorageWriteService getWriteService() {
            return this.writeService;
        }
    }
}

