package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ProfileStoreServiceRuntimeDelegatable extends ProfileStoreService {
    private final ProfileStoreService delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ProfileStoreServiceRuntimeDelegatable(@Nullable OverridesRegistry context,
            GsonSerde serde, UserProfileCache profileCache, DFSConfig dfsConfig,
            BucketAccessService access, StorageWriteService writeService) {
        super(serde, profileCache, dfsConfig, access, writeService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(serde, profileCache, dfsConfig, access, writeService);
        delegate = context != null ? context.findOverride(ProfileStoreService.class, argumentsCaptor) : null;
    }

    @Override
    public void registerPrivate(UserID id, UserPrivateProfile profile) {
        if (null == delegate) {
            super.registerPrivate(id, profile);
        } else {
            delegate.registerPrivate(id, profile);
        }
    }

    @Override
    public void registerPublic(UserID id, UserPublicProfile profile) {
        if (null == delegate) {
            super.registerPublic(id, profile);
        } else {
            delegate.registerPublic(id, profile);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ProfileStoreService> ctorCaptor) {
        context.override(ProfileStoreService.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final GsonSerde serde;

        private final UserProfileCache profileCache;

        private final DFSConfig dfsConfig;

        private final BucketAccessService access;

        private final StorageWriteService writeService;

        private ArgumentsCaptor(GsonSerde serde, UserProfileCache profileCache, DFSConfig dfsConfig,
                BucketAccessService access, StorageWriteService writeService) {
            this.serde = serde;
            this.profileCache = profileCache;
            this.dfsConfig = dfsConfig;
            this.access = access;
            this.writeService = writeService;
        }

        public GsonSerde getSerde() {
            return serde;
        }

        public UserProfileCache getProfileCache() {
            return profileCache;
        }

        public DFSConfig getDfsConfig() {
            return dfsConfig;
        }

        public BucketAccessService getAccess() {
            return access;
        }

        public StorageWriteService getWriteService() {
            return writeService;
        }
    }
}
