package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DefaultKeyStoreCacheRuntimeDelegatable extends DefaultKeyStoreCache {
    private final DefaultKeyStoreCache delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DefaultKeyStoreCacheRuntimeDelegatable(@Nullable OverridesRegistry context,
            Map<UserID, List<PublicKeyIDWithPublicKey>> publicKeys, Map<UserID, KeyStore> keystore,
            Map<UserID, KeyStore> storageAccess) {
        super(publicKeys, keystore, storageAccess);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(publicKeys, keystore, storageAccess);
        delegate = context != null ? context.findOverride(DefaultKeyStoreCache.class, argumentsCaptor) : null;
    }

    @Override
    public void remove(UserID userID) {
        if (null == delegate) {
            super.remove(userID);
        } else {
            delegate.remove(userID);
        }
    }

    @Override
    public Map<UserID, List<PublicKeyIDWithPublicKey>> getPublicKeys() {
        if (null == delegate) {
            return super.getPublicKeys();
        } else {
            return delegate.getPublicKeys();
        }
    }

    @Override
    public Map<UserID, KeyStore> getKeystore() {
        if (null == delegate) {
            return super.getKeystore();
        } else {
            return delegate.getKeystore();
        }
    }

    @Override
    public Map<UserID, KeyStore> getStorageAccess() {
        if (null == delegate) {
            return super.getStorageAccess();
        } else {
            return delegate.getStorageAccess();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DefaultKeyStoreCache> ctorCaptor) {
        context.override(DefaultKeyStoreCache.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final Map<UserID, List<PublicKeyIDWithPublicKey>> publicKeys;

        private final Map<UserID, KeyStore> keystore;

        private final Map<UserID, KeyStore> storageAccess;

        private ArgumentsCaptor(Map<UserID, List<PublicKeyIDWithPublicKey>> publicKeys,
                Map<UserID, KeyStore> keystore, Map<UserID, KeyStore> storageAccess) {
            this.publicKeys = publicKeys;
            this.keystore = keystore;
            this.storageAccess = storageAccess;
        }

        public Map<UserID, List<PublicKeyIDWithPublicKey>> getPublicKeys() {
            return publicKeys;
        }

        public Map<UserID, KeyStore> getKeystore() {
            return keystore;
        }

        public Map<UserID, KeyStore> getStorageAccess() {
            return storageAccess;
        }
    }
}
