/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.types.StorageCredentials;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAccess;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class StorageKeyStoreOperationsImpl
implements StorageKeyStoreOperations {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageKeyStoreOperationsImpl.class);
    private final GsonSerde gson;
    private final KeyStoreService keyStoreService;
    private final GenericKeystoreOperations genericOper;
    private final ProfileRetrievalService profile;
    private final BucketAccessService access;
    private final KeyStoreCache keystoreCache;

    @Inject
    public StorageKeyStoreOperationsImpl(GsonSerde gson, KeyStoreService keyStoreService, GenericKeystoreOperations genericOper, ProfileRetrievalService profile, BucketAccessService access, KeyStoreCache keystoreCache) {
        this.gson = gson;
        this.keyStoreService = keyStoreService;
        this.genericOper = genericOper;
        this.profile = profile;
        this.access = access;
        this.keystoreCache = keystoreCache;
    }

    public StorageCredentials getStorageCredentials(UserIDAuth forUser, StorageIdentifier id) {
        if (null == this.storageKeystoreLocation(forUser)) {
            return null;
        }
        String key = new String(this.genericOper.getKey(() -> this.keyStore(forUser), forUser, id.getId()).getEncoded(), StandardCharsets.UTF_8);
        return this.deserialize(key.toCharArray());
    }

    public Set<StorageIdentifier> readAliases(UserIDAuth forUser) {
        if (null == this.storageKeystoreLocation(forUser)) {
            return Collections.emptySet();
        }
        return this.genericOper.readAliases(this.keyStore(forUser)).stream().map(StorageIdentifier::new).collect(Collectors.toSet());
    }

    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        if (null == this.storageKeystoreLocation(forUser)) {
            return;
        }
        log.debug("Updating users' '{}' storage keystore ReadKeyPassword", (Object)forUser.getUserID());
        AbsoluteLocation location = this.keystoreLocationWithAccess(forUser);
        this.genericOper.updateReadKeyPassword(this.keyStore(forUser), location, forUser, newPassword);
    }

    public void createAndWriteKeystore(UserIDAuth forUser) {
        AbsoluteLocation location = this.keystoreLocationWithAccess(forUser);
        this.genericOper.writeKeystore(forUser.getUserID(), this.genericOper.keystoreAuth(forUser), location, this.newKeystore(forUser));
    }

    public void addStorageCredentials(UserIDAuth forUser, StorageIdentifier storageId, StorageCredentials credentials) {
        this.modifyAndStoreKeystore(forUser, keyStoreAccess -> this.keyStoreService.addPasswordBasedSecretKey(keyStoreAccess, storageId.getId(), this.serialize(credentials)));
    }

    public void removeStorageCredentials(UserIDAuth forUser, StorageIdentifier storageId) {
        this.modifyAndStoreKeystore(forUser, keyStoreAccess -> this.keyStoreService.removeKey(keyStoreAccess, storageId.getId()));
    }

    public void invalidateCache(UserIDAuth forUser) {
        this.keystoreCache.getStorageAccess().remove(forUser.getUserID());
    }

    private void modifyAndStoreKeystore(UserIDAuth forUser, Consumer<KeyStoreAccess> keystoreModifier) {
        log.debug("Modifying users' '{}' keystore", (Object)forUser.getUserID());
        AbsoluteLocation location = this.keystoreLocationWithAccess(forUser);
        KeyStoreAccess keystoreWithCreds = new KeyStoreAccess(this.genericOper.readKeyStore(forUser, location), this.genericOper.keystoreAuth(forUser));
        keystoreModifier.accept(keystoreWithCreds);
        this.genericOper.writeKeystore(forUser.getUserID(), this.genericOper.keystoreAuth(forUser), location, keystoreWithCreds.getKeyStore());
        this.invalidateCache(forUser);
    }

    protected KeyStore newKeystore(UserIDAuth forUser) {
        return this.genericOper.createEmptyKeystore(forUser);
    }

    private StorageCredentials deserialize(char[] data) {
        return this.gson.fromJson(new String(data), StorageCredentials.class);
    }

    private char[] serialize(StorageCredentials credentials) {
        return this.gson.toJson(credentials).toCharArray();
    }

    private AbsoluteLocation keystoreLocationWithAccess(UserIDAuth forUser) {
        AbsoluteLocation<PrivateResource> location = this.storageKeystoreLocation(forUser);
        if (null == location) {
            throw new IllegalStateException("Profile does not have associated storage keystore");
        }
        return this.access.withSystemAccess(location);
    }

    private AbsoluteLocation<PrivateResource> storageKeystoreLocation(UserIDAuth forUser) {
        return this.profile.privateProfile(forUser).getStorageCredentialsKeystore();
    }

    private KeyStore keyStore(UserIDAuth forUser) {
        return this.keystoreCache.getStorageAccess().computeIfAbsent(forUser.getUserID(), userId -> {
            AbsoluteLocation location = this.keystoreLocationWithAccess(forUser);
            return this.genericOper.readKeyStore(forUser, location);
        });
    }
}

