/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.security.Key;
import java.security.KeyStore;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class GenericKeystoreOperationsRuntimeDelegatable
extends GenericKeystoreOperations {
    private final GenericKeystoreOperations delegate;

    @Inject
    public GenericKeystoreOperationsRuntimeDelegatable(@Nullable OverridesRegistry context, DFSConfig dfsConfig, StorageWriteService writeService, StorageReadService readService, KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
        super(dfsConfig, writeService, readService, keystoreCache, keyStoreService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(dfsConfig, writeService, readService, keystoreCache, keyStoreService);
        this.delegate = context != null ? (GenericKeystoreOperations)context.findOverride(GenericKeystoreOperations.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public KeyStore createEmptyKeystore(UserIDAuth auth) {
        if (null == this.delegate) {
            return super.createEmptyKeystore(auth);
        }
        return this.delegate.createEmptyKeystore(auth);
    }

    @Override
    public Key getKey(Supplier<KeyStore> keystore, UserIDAuth forUser, String alias) {
        if (null == this.delegate) {
            return super.getKey(keystore, forUser, alias);
        }
        return this.delegate.getKey(keystore, forUser, alias);
    }

    @Override
    public Set<String> readAliases(KeyStore keystore) {
        if (null == this.delegate) {
            return super.readAliases(keystore);
        }
        return this.delegate.readAliases(keystore);
    }

    @Override
    public void updateReadKeyPassword(KeyStore keystore, AbsoluteLocation location, UserIDAuth forUser, ReadKeyPassword newPassword) {
        if (null == this.delegate) {
            super.updateReadKeyPassword(keystore, location, forUser, newPassword);
        } else {
            this.delegate.updateReadKeyPassword(keystore, location, forUser, newPassword);
        }
    }

    @Override
    public KeyStore readKeyStore(UserIDAuth forUser, AbsoluteLocation location) {
        if (null == this.delegate) {
            return super.readKeyStore(forUser, location);
        }
        return this.delegate.readKeyStore(forUser, location);
    }

    @Override
    public KeyStoreAuth keystoreAuth(UserIDAuth forUser) {
        if (null == this.delegate) {
            return super.keystoreAuth(forUser);
        }
        return this.delegate.keystoreAuth(forUser);
    }

    @Override
    public void writeKeystore(UserID forUser, KeyStoreAuth auth, AbsoluteLocation locationWithAccess, KeyStore keystoreBlob) {
        if (null == this.delegate) {
            super.writeKeystore(forUser, auth, locationWithAccess, keystoreBlob);
        } else {
            this.delegate.writeKeystore(forUser, auth, locationWithAccess, keystoreBlob);
        }
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, GenericKeystoreOperations> ctorCaptor) {
        context.override(GenericKeystoreOperations.class, args -> (GenericKeystoreOperations)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final DFSConfig dfsConfig;
        private final StorageWriteService writeService;
        private final StorageReadService readService;
        private final KeyStoreCache keystoreCache;
        private final KeyStoreService keyStoreService;

        private ArgumentsCaptor(DFSConfig dfsConfig, StorageWriteService writeService, StorageReadService readService, KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
            this.dfsConfig = dfsConfig;
            this.writeService = writeService;
            this.readService = readService;
            this.keystoreCache = keystoreCache;
            this.keyStoreService = keyStoreService;
        }

        public DFSConfig getDfsConfig() {
            return this.dfsConfig;
        }

        public StorageWriteService getWriteService() {
            return this.writeService;
        }

        public StorageReadService getReadService() {
            return this.readService;
        }

        public KeyStoreCache getKeystoreCache() {
            return this.keystoreCache;
        }

        public KeyStoreService getKeyStoreService() {
            return this.keyStoreService;
        }
    }
}

