/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class GenericKeystoreOperations {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericKeystoreOperations.class);
    private final DFSConfig dfsConfig;
    private final StorageWriteService writeService;
    private final StorageReadService readService;
    private final KeyStoreCache keystoreCache;
    private final KeyStoreService keyStoreService;

    @Inject
    public GenericKeystoreOperations(DFSConfig dfsConfig, StorageWriteService writeService, StorageReadService readService, KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
        this.dfsConfig = dfsConfig;
        this.writeService = writeService;
        this.readService = readService;
        this.keystoreCache = keystoreCache;
        this.keyStoreService = keyStoreService;
    }

    public KeyStore createEmptyKeystore(UserIDAuth auth) {
        return this.keyStoreService.createKeyStore(this.keystoreAuth(auth), KeyStoreType.DEFAULT, new KeyStoreCreationConfig(0, 0));
    }

    public Key getKey(Supplier<KeyStore> keystore, UserIDAuth forUser, String alias) {
        try {
            return keystore.get().getKey(alias, forUser.getReadKeyPassword().getValue().toCharArray());
        }
        catch (UnrecoverableKeyException ex) {
            this.keystoreCache.remove(forUser.getUserID());
            return keystore.get().getKey(alias, forUser.getReadKeyPassword().getValue().toCharArray());
        }
    }

    public Set<String> readAliases(KeyStore keystore) {
        HashSet<String> result = new HashSet<String>();
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            result.add(aliases.nextElement());
        }
        return result;
    }

    public void updateReadKeyPassword(KeyStore keystore, AbsoluteLocation location, UserIDAuth forUser, ReadKeyPassword newPassword) {
        log.debug("Updating users' '{}' keystore ReadKeyPassword", (Object)forUser.getUserID());
        KeyStoreAuth newAuth = this.keystoreAuth(forUser, newPassword);
        KeyStore newKeystore = this.keyStoreService.updateKeyStoreReadKeyPassword(keystore, this.keystoreAuth(forUser), newAuth);
        this.writeKeystore(forUser.getUserID(), newAuth, location, newKeystore);
        this.keystoreCache.remove(forUser.getUserID());
        log.debug("Users' '{}' keystore ReadKeyPassword updated", (Object)forUser.getUserID());
    }

    public KeyStore readKeyStore(UserIDAuth forUser, AbsoluteLocation location) {
        byte[] payload;
        try (InputStream is = this.readService.read(location);){
            payload = ByteStreams.toByteArray((InputStream)is);
        }
        return this.keyStoreService.deserialize(payload, forUser.getUserID().getValue(), this.dfsConfig.privateKeyStoreAuth(forUser).getReadStorePassword());
    }

    public KeyStoreAuth keystoreAuth(UserIDAuth forUser) {
        return this.keystoreAuth(forUser, forUser.getReadKeyPassword());
    }

    public void writeKeystore(UserID forUser, KeyStoreAuth auth, AbsoluteLocation locationWithAccess, KeyStore keystoreBlob) {
        try (OutputStream os = this.writeService.write(WithCallback.noCallback((Object)locationWithAccess));){
            os.write(this.keyStoreService.serialize(keystoreBlob, forUser.getValue(), auth.getReadStorePassword()));
        }
        log.debug("Keystore written for user {} in path {}", (Object)forUser, (Object)locationWithAccess);
    }

    private KeyStoreAuth keystoreAuth(UserIDAuth forUser, ReadKeyPassword newPassword) {
        ReadStorePassword readStorePassword = this.dfsConfig.privateKeyStoreAuth(forUser).getReadStorePassword();
        return new KeyStoreAuth(readStorePassword, newPassword);
    }
}

