/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import com.google.common.collect.Streams;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRemovalService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.exceptions.UserNotFoundException;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.storage.api.actions.StorageRemoveService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class ProfileRemovalServiceImpl
implements ProfileRemovalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileRemovalServiceImpl.class);
    private final PrivateKeyService privateKeyService;
    private final KeyStoreCache keyStoreCache;
    private final UserProfileCache profileCache;
    private final StorageListService listService;
    private final BucketAccessService access;
    private final DFSConfig dfsConfig;
    private final StorageRemoveService removeService;
    private final ProfileRetrievalService retrievalService;

    @Inject
    public ProfileRemovalServiceImpl(PrivateKeyService privateKeyService, KeyStoreCache keyStoreCache, UserProfileCache profileCache, StorageListService listService, BucketAccessService access, DFSConfig dfsConfig, StorageRemoveService removeService, ProfileRetrievalService retrievalService) {
        this.privateKeyService = privateKeyService;
        this.keyStoreCache = keyStoreCache;
        this.profileCache = profileCache;
        this.listService = listService;
        this.access = access;
        this.dfsConfig = dfsConfig;
        this.removeService = removeService;
        this.retrievalService = retrievalService;
    }

    public void deregister(UserIDAuth userID) {
        if (!this.retrievalService.userExists(userID.getUserID())) {
            log.debug("User deregistation failed. User '{}' does not exist", (Object)userID);
            throw new UserNotFoundException("User not found: " + userID);
        }
        this.privateKeyService.documentEncryptionSecretKey(userID);
        UserPublicProfile publicProfile = this.retrievalService.publicProfile(userID.getUserID());
        UserPrivateProfile privateProfile = this.retrievalService.privateProfile(userID);
        privateProfile.getPrivateStorage().forEach((id, path) -> this.removeAllIn(userID, (AbsoluteLocation<PrivateResource>)path));
        this.removeAllIn(userID, (AbsoluteLocation<PrivateResource>)privateProfile.getInboxWithFullAccess());
        this.removeAllIn(userID, (AbsoluteLocation<PrivateResource>)privateProfile.getDocumentVersionStorage());
        Streams.concat((Stream[])new Stream[]{Stream.of(privateProfile.getKeystore(), privateProfile.getInboxWithFullAccess(), privateProfile.getDocumentVersionStorage(), privateProfile.getStorageCredentialsKeystore()), privateProfile.getPrivateStorage().values().stream()}).filter(Objects::nonNull).map(AbsoluteLocation::getResource).map(it -> this.access.privateAccessFor(userID, it)).forEach(arg_0 -> ((StorageRemoveService)this.removeService).remove(arg_0));
        this.removeService.remove(this.access.withSystemAccess(publicProfile.getPublicKeys()));
        this.removeUserProfileFiles(userID.getUserID());
        privateProfile.getAssociatedResources().stream().map(it -> this.access.privateAccessFor(userID, (PrivateResource)it.getResource())).forEach(arg_0 -> ((StorageRemoveService)this.removeService).remove(arg_0));
        this.cleanupProfileCache(userID.getUserID());
        this.keyStoreCache.remove(userID.getUserID());
        log.debug("Deregistered user {}", (Object)userID);
    }

    protected void removeUserProfileFiles(UserID forUser) {
        this.removeService.remove(this.access.withSystemAccess(this.dfsConfig.privateProfile(forUser)));
        this.removeService.remove(this.access.withSystemAccess(this.dfsConfig.publicProfile(forUser)));
    }

    protected void cleanupProfileCache(UserID forUser) {
        this.profileCache.getPrivateProfile().remove(forUser);
        this.profileCache.getPublicProfile().remove(forUser);
    }

    private void removeAllIn(UserIDAuth userID, AbsoluteLocation<PrivateResource> location) {
        if (null == location) {
            return;
        }
        this.listService.list(this.access.privateAccessFor(userID, (PrivateResource)location.getResource())).forEach(arg_0 -> ((StorageRemoveService)this.removeService).remove(arg_0));
    }
}

