/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.DocumentKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAccess;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class DocumentKeyStoreOperationsImpl
implements DocumentKeyStoreOperations {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentKeyStoreOperationsImpl.class);
    private final GenericKeystoreOperations genericOper;
    private final DFSConfig dfsConfig;
    private final BucketAccessService access;
    private final ProfileRetrievalService profile;
    private final StorageWriteService writeService;
    private final KeyStoreCache keystoreCache;
    private final KeyStoreService keyStoreService;

    @Inject
    public DocumentKeyStoreOperationsImpl(GenericKeystoreOperations genericOper, DFSConfig dfsConfig, BucketAccessService access, ProfileRetrievalService profile, StorageWriteService writeService, KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
        this.genericOper = genericOper;
        this.dfsConfig = dfsConfig;
        this.access = access;
        this.profile = profile;
        this.writeService = writeService;
        this.keystoreCache = keystoreCache;
        this.keyStoreService = keyStoreService;
    }

    public Key getKey(UserIDAuth forUser, String alias) {
        return this.genericOper.getKey(() -> this.keyStore(forUser), forUser, alias);
    }

    public Set<String> readAliases(UserIDAuth forUser) {
        return this.genericOper.readAliases(this.keyStore(forUser));
    }

    public List<PublicKeyIDWithPublicKey> createAndWriteKeyStore(UserIDAuth forUser) {
        KeyStoreAuth auth = this.keystoreAuth(forUser, forUser.getReadKeyPassword());
        KeyStore keystoreBlob = this.keyStoreService.createKeyStore(auth, KeyStoreType.DEFAULT, new KeyStoreCreationConfig(1, 1));
        this.writeKeystore(forUser.getUserID(), auth, this.keystoreLocationWithAccess(forUser), keystoreBlob);
        return this.keyStoreService.getPublicKeys(new KeyStoreAccess(keystoreBlob, auth));
    }

    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        log.debug("Updating users' '{}' document keystore ReadKeyPassword", (Object)forUser.getUserID());
        AbsoluteLocation<PrivateResource> location = this.keystoreLocationWithAccess(forUser);
        this.genericOper.updateReadKeyPassword(this.keyStore(forUser), location, forUser, newPassword);
    }

    private AbsoluteLocation<PrivateResource> keystoreLocationWithAccess(UserIDAuth forUser) {
        return this.access.privateAccessFor(forUser, (PrivateResource)this.profile.privateProfile(forUser).getKeystore().getResource());
    }

    private KeyStoreAuth keystoreAuth(UserIDAuth forUser, ReadKeyPassword readKeyPassword) {
        ReadStorePassword readStorePassword = this.dfsConfig.privateKeyStoreAuth(forUser).getReadStorePassword();
        return new KeyStoreAuth(readStorePassword, readKeyPassword);
    }

    private <T extends ResourceLocation<T>> void writeKeystore(UserID forUser, KeyStoreAuth auth, AbsoluteLocation<T> keystore, KeyStore keystoreBlob) {
        try (OutputStream os = this.writeService.write(WithCallback.noCallback((Object)this.access.withSystemAccess(keystore)));){
            os.write(this.keyStoreService.serialize(keystoreBlob, forUser.getValue(), auth.getReadStorePassword()));
        }
        log.debug("Keystore created for user {} in path {}", (Object)forUser, keystore);
    }

    private KeyStore keyStore(UserIDAuth forUser) {
        return this.keystoreCache.getKeystore().computeIfAbsent(forUser.getUserID(), userId -> {
            AbsoluteLocation<PrivateResource> location = this.keystoreLocationWithAccess(forUser);
            return this.genericOper.readKeyStore(forUser, location);
        });
    }
}

