/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.config;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultUserProfileLocationImpl;
import de.adorsys.datasafe.directory.impl.profile.config.UserProfileLocation;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BasePublicResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.net.URI;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDFSConfig
implements DFSConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDFSConfig.class);
    protected static final String USERS_ROOT = "users/";
    protected static final String PRIVATE_COMPONENT = "private";
    protected static final String PRIVATE_FILES_COMPONENT = "private/files";
    protected static final String PUBLIC_COMPONENT = "public";
    protected static final String INBOX_COMPONENT = "public/inbox";
    protected static final String VERSION_COMPONENT = "versions";
    protected final Uri systemRoot;
    protected final ReadStorePassword systemPassword;
    protected final UserProfileLocation userProfileLocation;

    public DefaultDFSConfig(String systemRoot, String systemPassword) {
        this(new Uri(systemRoot), systemPassword);
    }

    public DefaultDFSConfig(URI systemRoot, String systemPassword) {
        this(new Uri(systemRoot), systemPassword);
    }

    public DefaultDFSConfig(Uri systemRoot, String systemPassword) {
        this(systemRoot, systemPassword, (UserProfileLocation)new DefaultUserProfileLocationImpl(systemRoot));
    }

    public DefaultDFSConfig(Uri systemRoot, String systemPassword, UserProfileLocation userProfileLocation) {
        this.systemRoot = systemRoot = DefaultDFSConfig.addTrailingSlashIfNeeded(systemRoot);
        this.systemPassword = new ReadStorePassword(systemPassword);
        this.userProfileLocation = userProfileLocation;
        log.debug("Root is {}", this.dfsRoot());
    }

    public KeyStoreAuth privateKeyStoreAuth(UserIDAuth auth) {
        return new KeyStoreAuth(this.systemPassword, auth.getReadKeyPassword());
    }

    public AbsoluteLocation publicProfile(UserID forUser) {
        return this.locatePublicProfile(forUser);
    }

    public AbsoluteLocation privateProfile(UserID forUser) {
        return this.locatePrivateProfile(forUser);
    }

    public CreateUserPrivateProfile defaultPrivateTemplate(UserIDAuth id) {
        Uri rootLocation = this.userRoot(id.getUserID());
        Uri keyStoreUri = rootLocation.resolve("private/keystore");
        Uri filesUri = rootLocation.resolve("private/files/");
        return CreateUserPrivateProfile.builder().id(id).privateStorage(this.accessPrivate(filesUri)).keystore(this.accessPrivate(keyStoreUri)).inboxWithWriteAccess(this.accessPrivate(this.inbox(rootLocation))).documentVersionStorage(this.accessPrivate(rootLocation.resolve("./versions/"))).publishPubKeysTo(this.access(this.publicKeys(rootLocation))).associatedResources(Collections.singletonList(this.accessPrivate(rootLocation))).build();
    }

    public CreateUserPublicProfile defaultPublicTemplate(UserID id) {
        Uri rootLocation = this.userRoot(id);
        return CreateUserPublicProfile.builder().id(id).inbox(this.access(this.inbox(rootLocation))).publicKeys(this.access(this.publicKeys(rootLocation))).build();
    }

    protected Uri userRoot(UserID userID) {
        return this.dfsRoot().location().resolve(USERS_ROOT).resolve(userID.getValue() + "/");
    }

    protected AbsoluteLocation<PublicResource> dfsRoot() {
        return new AbsoluteLocation((ResourceLocation)new BasePublicResource(this.systemRoot));
    }

    protected AbsoluteLocation<PrivateResource> locatePrivateProfile(UserID ofUser) {
        return this.userProfileLocation.locatePrivateProfile(ofUser);
    }

    protected AbsoluteLocation<PublicResource> locatePublicProfile(UserID ofUser) {
        return this.userProfileLocation.locatePublicProfile(ofUser);
    }

    protected AbsoluteLocation<PublicResource> access(Uri path) {
        return new AbsoluteLocation((ResourceLocation)new BasePublicResource(path));
    }

    protected AbsoluteLocation<PrivateResource> accessPrivate(Uri path) {
        return new AbsoluteLocation((ResourceLocation)new BasePrivateResource(path, new Uri(""), new Uri("")));
    }

    protected Uri inbox(Uri rootLocation) {
        return rootLocation.resolve("./public/inbox/");
    }

    protected Uri publicKeys(Uri rootLocation) {
        return rootLocation.resolve("./public/pubkeys");
    }

    public static Uri addTrailingSlashIfNeeded(Uri systemRoot) {
        return new Uri(DefaultDFSConfig.addTrailingSlashIfNeeded(systemRoot.asURI()));
    }

    public static URI addTrailingSlashIfNeeded(URI systemRoot) {
        return new URI(DefaultDFSConfig.addTrailingSlashIfNeeded(systemRoot.toASCIIString()));
    }

    public static String addTrailingSlashIfNeeded(String systemRoot) {
        if (systemRoot == null) {
            throw new RuntimeException("systemRoot must not be null");
        }
        int last = systemRoot.length();
        if (systemRoot.substring(last - 1).equals("/")) {
            return systemRoot;
        }
        return systemRoot + "/";
    }

    @Generated
    public DefaultDFSConfig(Uri systemRoot, ReadStorePassword systemPassword, UserProfileLocation userProfileLocation) {
        this.systemRoot = systemRoot;
        this.systemPassword = systemPassword;
        this.userProfileLocation = userProfileLocation;
    }
}

