package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.lang.Override;
import java.lang.String;
import java.security.Key;
import java.security.KeyStore;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class GenericKeystoreOperationsRuntimeDelegatable extends GenericKeystoreOperations {
    private final GenericKeystoreOperations delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public GenericKeystoreOperationsRuntimeDelegatable(@Nullable OverridesRegistry context,
            DFSConfig dfsConfig, StorageWriteService writeService, StorageReadService readService,
            KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
        super(dfsConfig, writeService, readService, keystoreCache, keyStoreService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(dfsConfig, writeService, readService, keystoreCache, keyStoreService);
        delegate = context != null ? context.findOverride(GenericKeystoreOperations.class, argumentsCaptor) : null;
    }

    @Override
    public KeyStore createEmptyKeystore(UserIDAuth auth) {
        if (null == delegate) {
            return super.createEmptyKeystore(auth);
        } else {
            return delegate.createEmptyKeystore(auth);
        }
    }

    @Override
    public Key getKey(Supplier<KeyStore> keystore, UserIDAuth forUser, String alias) {
        if (null == delegate) {
            return super.getKey(keystore, forUser, alias);
        } else {
            return delegate.getKey(keystore, forUser, alias);
        }
    }

    @Override
    public Set<String> readAliases(KeyStore keystore) {
        if (null == delegate) {
            return super.readAliases(keystore);
        } else {
            return delegate.readAliases(keystore);
        }
    }

    @Override
    public void updateReadKeyPassword(KeyStore keystore, AbsoluteLocation location,
            UserIDAuth forUser, ReadKeyPassword newPassword) {
        if (null == delegate) {
            super.updateReadKeyPassword(keystore, location, forUser, newPassword);
        } else {
            delegate.updateReadKeyPassword(keystore, location, forUser, newPassword);
        }
    }

    @Override
    public KeyStore readKeyStore(UserIDAuth forUser, AbsoluteLocation location) {
        if (null == delegate) {
            return super.readKeyStore(forUser, location);
        } else {
            return delegate.readKeyStore(forUser, location);
        }
    }

    @Override
    public KeyStoreAuth keystoreAuth(UserIDAuth forUser) {
        if (null == delegate) {
            return super.keystoreAuth(forUser);
        } else {
            return delegate.keystoreAuth(forUser);
        }
    }

    @Override
    public void writeKeystore(UserID forUser, KeyStoreAuth auth,
            AbsoluteLocation locationWithAccess, KeyStore keystoreBlob) {
        if (null == delegate) {
            super.writeKeystore(forUser, auth, locationWithAccess, keystoreBlob);
        } else {
            delegate.writeKeystore(forUser, auth, locationWithAccess, keystoreBlob);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, GenericKeystoreOperations> ctorCaptor) {
        context.override(GenericKeystoreOperations.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final DFSConfig dfsConfig;

        private final StorageWriteService writeService;

        private final StorageReadService readService;

        private final KeyStoreCache keystoreCache;

        private final KeyStoreService keyStoreService;

        private ArgumentsCaptor(DFSConfig dfsConfig, StorageWriteService writeService,
                StorageReadService readService, KeyStoreCache keystoreCache,
                KeyStoreService keyStoreService) {
            this.dfsConfig = dfsConfig;
            this.writeService = writeService;
            this.readService = readService;
            this.keystoreCache = keystoreCache;
            this.keyStoreService = keyStoreService;
        }

        public DFSConfig getDfsConfig() {
            return dfsConfig;
        }

        public StorageWriteService getWriteService() {
            return writeService;
        }

        public StorageReadService getReadService() {
            return readService;
        }

        public KeyStoreCache getKeystoreCache() {
            return keystoreCache;
        }

        public KeyStoreService getKeyStoreService() {
            return keyStoreService;
        }
    }
}
