package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.lang.String;
import java.security.Key;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DocumentKeyStoreOperationsImplRuntimeDelegatable extends DocumentKeyStoreOperationsImpl {
    private final DocumentKeyStoreOperationsImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DocumentKeyStoreOperationsImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            GenericKeystoreOperations genericOper, DFSConfig dfsConfig, BucketAccessService access,
            ProfileRetrievalService profile, StorageWriteService writeService,
            KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
        super(genericOper, dfsConfig, access, profile, writeService, keystoreCache, keyStoreService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(genericOper, dfsConfig, access, profile, writeService, keystoreCache, keyStoreService);
        delegate = context != null ? context.findOverride(DocumentKeyStoreOperationsImpl.class, argumentsCaptor) : null;
    }

    @Override
    public Key getKey(UserIDAuth forUser, String alias) {
        if (null == delegate) {
            return super.getKey(forUser, alias);
        } else {
            return delegate.getKey(forUser, alias);
        }
    }

    @Override
    public Set<String> readAliases(UserIDAuth forUser) {
        if (null == delegate) {
            return super.readAliases(forUser);
        } else {
            return delegate.readAliases(forUser);
        }
    }

    @Override
    public List<PublicKeyIDWithPublicKey> createAndWriteKeyStore(UserIDAuth forUser) {
        if (null == delegate) {
            return super.createAndWriteKeyStore(forUser);
        } else {
            return delegate.createAndWriteKeyStore(forUser);
        }
    }

    @Override
    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        if (null == delegate) {
            super.updateReadKeyPassword(forUser, newPassword);
        } else {
            delegate.updateReadKeyPassword(forUser, newPassword);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DocumentKeyStoreOperationsImpl> ctorCaptor) {
        context.override(DocumentKeyStoreOperationsImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final GenericKeystoreOperations genericOper;

        private final DFSConfig dfsConfig;

        private final BucketAccessService access;

        private final ProfileRetrievalService profile;

        private final StorageWriteService writeService;

        private final KeyStoreCache keystoreCache;

        private final KeyStoreService keyStoreService;

        private ArgumentsCaptor(GenericKeystoreOperations genericOper, DFSConfig dfsConfig,
                BucketAccessService access, ProfileRetrievalService profile,
                StorageWriteService writeService, KeyStoreCache keystoreCache,
                KeyStoreService keyStoreService) {
            this.genericOper = genericOper;
            this.dfsConfig = dfsConfig;
            this.access = access;
            this.profile = profile;
            this.writeService = writeService;
            this.keystoreCache = keystoreCache;
            this.keyStoreService = keyStoreService;
        }

        public GenericKeystoreOperations getGenericOper() {
            return genericOper;
        }

        public DFSConfig getDfsConfig() {
            return dfsConfig;
        }

        public BucketAccessService getAccess() {
            return access;
        }

        public ProfileRetrievalService getProfile() {
            return profile;
        }

        public StorageWriteService getWriteService() {
            return writeService;
        }

        public KeyStoreCache getKeystoreCache() {
            return keystoreCache;
        }

        public KeyStoreService getKeyStoreService() {
            return keyStoreService;
        }
    }
}
