/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreOperationsImpl;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.security.Key;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class KeyStoreOperationsImplRuntimeDelegatable
extends KeyStoreOperationsImpl {
    private final KeyStoreOperationsImpl delegate;

    @Inject
    public KeyStoreOperationsImplRuntimeDelegatable(@Nullable OverridesRegistry context, DFSConfig dfsConfig, BucketAccessService access, ProfileRetrievalService profile, StorageReadService readService, StorageWriteService writeService, KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
        super(dfsConfig, access, profile, readService, writeService, keystoreCache, keyStoreService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(dfsConfig, access, profile, readService, writeService, keystoreCache, keyStoreService);
        this.delegate = context != null ? (KeyStoreOperationsImpl)context.findOverride(KeyStoreOperationsImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public Key getKey(UserIDAuth forUser, String alias) {
        if (null == this.delegate) {
            return super.getKey(forUser, alias);
        }
        return this.delegate.getKey(forUser, alias);
    }

    @Override
    public Set<String> readAliases(UserIDAuth forUser) {
        if (null == this.delegate) {
            return super.readAliases(forUser);
        }
        return this.delegate.readAliases(forUser);
    }

    @Override
    public List<PublicKeyIDWithPublicKey> createAndWriteKeyStore(UserIDAuth forUser) {
        if (null == this.delegate) {
            return super.createAndWriteKeyStore(forUser);
        }
        return this.delegate.createAndWriteKeyStore(forUser);
    }

    @Override
    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        if (null == this.delegate) {
            super.updateReadKeyPassword(forUser, newPassword);
        } else {
            this.delegate.updateReadKeyPassword(forUser, newPassword);
        }
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, KeyStoreOperationsImpl> ctorCaptor) {
        context.override(KeyStoreOperationsImpl.class, args -> (KeyStoreOperationsImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final DFSConfig dfsConfig;
        private final BucketAccessService access;
        private final ProfileRetrievalService profile;
        private final StorageReadService readService;
        private final StorageWriteService writeService;
        private final KeyStoreCache keystoreCache;
        private final KeyStoreService keyStoreService;

        private ArgumentsCaptor(DFSConfig dfsConfig, BucketAccessService access, ProfileRetrievalService profile, StorageReadService readService, StorageWriteService writeService, KeyStoreCache keystoreCache, KeyStoreService keyStoreService) {
            this.dfsConfig = dfsConfig;
            this.access = access;
            this.profile = profile;
            this.readService = readService;
            this.writeService = writeService;
            this.keystoreCache = keystoreCache;
            this.keyStoreService = keyStoreService;
        }

        public DFSConfig getDfsConfig() {
            return this.dfsConfig;
        }

        public BucketAccessService getAccess() {
            return this.access;
        }

        public ProfileRetrievalService getProfile() {
            return this.profile;
        }

        public StorageReadService getReadService() {
            return this.readService;
        }

        public StorageWriteService getWriteService() {
            return this.writeService;
        }

        public KeyStoreCache getKeystoreCache() {
            return this.keystoreCache;
        }

        public KeyStoreService getKeyStoreService() {
            return this.keyStoreService;
        }
    }
}

