package de.adorsys.datasafe.directory.impl.profile.resource;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ResourceResolverImplRuntimeDelegatable extends ResourceResolverImpl {
    private final ResourceResolverImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ResourceResolverImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            ProfileRetrievalService profile, BucketAccessService bucketAccessService) {
        super(profile, bucketAccessService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(profile, bucketAccessService);
        delegate = context != null ? context.findOverride(ResourceResolverImpl.class, argumentsCaptor) : null;
    }

    @Override
    public AbsoluteLocation<PublicResource> resolveRelativeToPublicInbox(UserID userID,
            PublicResource resource) {
        if (null == delegate) {
            return super.resolveRelativeToPublicInbox(userID, resource);
        } else {
            return delegate.resolveRelativeToPublicInbox(userID, resource);
        }
    }

    @Override
    public AbsoluteLocation<PrivateResource> resolveRelativeToPrivateInbox(UserIDAuth userID,
            PrivateResource resource) {
        if (null == delegate) {
            return super.resolveRelativeToPrivateInbox(userID, resource);
        } else {
            return delegate.resolveRelativeToPrivateInbox(userID, resource);
        }
    }

    @Override
    public AbsoluteLocation<PrivateResource> resolveRelativeToPrivate(UserIDAuth userID,
            PrivateResource resource) {
        if (null == delegate) {
            return super.resolveRelativeToPrivate(userID, resource);
        } else {
            return delegate.resolveRelativeToPrivate(userID, resource);
        }
    }

    @Override
    public <T extends ResourceLocation<T>> boolean isAbsolute(T resource) {
        if (null == delegate) {
            return super.isAbsolute(resource);
        } else {
            return delegate.isAbsolute(resource);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ResourceResolverImpl> ctorCaptor) {
        context.override(ResourceResolverImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final ProfileRetrievalService profile;

        private final BucketAccessService bucketAccessService;

        private ArgumentsCaptor(ProfileRetrievalService profile,
                BucketAccessService bucketAccessService) {
            this.profile = profile;
            this.bucketAccessService = bucketAccessService;
        }

        public ProfileRetrievalService getProfile() {
            return profile;
        }

        public BucketAccessService getBucketAccessService() {
            return bucketAccessService;
        }
    }
}
