package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.storage.api.actions.StorageRemoveService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ProfileRemovalServiceImplRuntimeDelegatable extends ProfileRemovalServiceImpl {
    private final ProfileRemovalServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ProfileRemovalServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            PrivateKeyService privateKeyService, KeyStoreCache keyStoreCache,
            UserProfileCache profileCache, StorageListService listService,
            BucketAccessService access, DFSConfig dfsConfig, StorageRemoveService removeService,
            ProfileRetrievalService retrievalService) {
        super(privateKeyService, keyStoreCache, profileCache, listService, access, dfsConfig, removeService, retrievalService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(privateKeyService, keyStoreCache, profileCache, listService, access, dfsConfig, removeService, retrievalService);
        delegate = context != null ? context.findOverride(ProfileRemovalServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public void deregister(UserIDAuth userID) {
        if (null == delegate) {
            super.deregister(userID);
        } else {
            delegate.deregister(userID);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ProfileRemovalServiceImpl> ctorCaptor) {
        context.override(ProfileRemovalServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final PrivateKeyService privateKeyService;

        private final KeyStoreCache keyStoreCache;

        private final UserProfileCache profileCache;

        private final StorageListService listService;

        private final BucketAccessService access;

        private final DFSConfig dfsConfig;

        private final StorageRemoveService removeService;

        private final ProfileRetrievalService retrievalService;

        private ArgumentsCaptor(PrivateKeyService privateKeyService, KeyStoreCache keyStoreCache,
                UserProfileCache profileCache, StorageListService listService,
                BucketAccessService access, DFSConfig dfsConfig, StorageRemoveService removeService,
                ProfileRetrievalService retrievalService) {
            this.privateKeyService = privateKeyService;
            this.keyStoreCache = keyStoreCache;
            this.profileCache = profileCache;
            this.listService = listService;
            this.access = access;
            this.dfsConfig = dfsConfig;
            this.removeService = removeService;
            this.retrievalService = retrievalService;
        }

        public PrivateKeyService getPrivateKeyService() {
            return privateKeyService;
        }

        public KeyStoreCache getKeyStoreCache() {
            return keyStoreCache;
        }

        public UserProfileCache getProfileCache() {
            return profileCache;
        }

        public StorageListService getListService() {
            return listService;
        }

        public BucketAccessService getAccess() {
            return access;
        }

        public DFSConfig getDfsConfig() {
            return dfsConfig;
        }

        public StorageRemoveService getRemoveService() {
            return removeService;
        }

        public ProfileRetrievalService getRetrievalService() {
            return retrievalService;
        }
    }
}
