package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DefaultKeyStoreCacheRuntimeDelegatable extends DefaultKeyStoreCache {
    private final DefaultKeyStoreCache delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DefaultKeyStoreCacheRuntimeDelegatable(@Nullable OverridesRegistry context,
            Map<UserID, List<PublicKeyIDWithPublicKey>> publicKeys,
            Map<UserID, KeyStore> keystore) {
        super(publicKeys, keystore);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(publicKeys, keystore);
        delegate = context != null ? context.findOverride(DefaultKeyStoreCache.class, argumentsCaptor) : null;
    }

    @Override
    public Map<UserID, List<PublicKeyIDWithPublicKey>> getPublicKeys() {
        if (null == delegate) {
            return super.getPublicKeys();
        } else {
            return delegate.getPublicKeys();
        }
    }

    @Override
    public Map<UserID, KeyStore> getKeystore() {
        if (null == delegate) {
            return super.getKeystore();
        } else {
            return delegate.getKeystore();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DefaultKeyStoreCache> ctorCaptor) {
        context.override(DefaultKeyStoreCache.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final Map<UserID, List<PublicKeyIDWithPublicKey>> publicKeys;

        private final Map<UserID, KeyStore> keystore;

        private ArgumentsCaptor(Map<UserID, List<PublicKeyIDWithPublicKey>> publicKeys,
                Map<UserID, KeyStore> keystore) {
            this.publicKeys = publicKeys;
            this.keystore = keystore;
        }

        public Map<UserID, List<PublicKeyIDWithPublicKey>> getPublicKeys() {
            return publicKeys;
        }

        public Map<UserID, KeyStore> getKeystore() {
            return keystore;
        }
    }
}
