package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.profile.keys.KeyStoreOperations;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.lang.String;
import java.security.Key;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DFSPrivateKeyServiceImplRuntimeDelegatable extends DFSPrivateKeyServiceImpl {
    private final DFSPrivateKeyServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DFSPrivateKeyServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            KeyStoreOperations keyStoreOper) {
        super(keyStoreOper);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keyStoreOper);
        delegate = context != null ? context.findOverride(DFSPrivateKeyServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public SecretKeyIDWithKey pathEncryptionSecretKey(UserIDAuth forUser) {
        if (null == delegate) {
            return super.pathEncryptionSecretKey(forUser);
        } else {
            return delegate.pathEncryptionSecretKey(forUser);
        }
    }

    @Override
    public SecretKeyIDWithKey documentEncryptionSecretKey(UserIDAuth forUser) {
        if (null == delegate) {
            return super.documentEncryptionSecretKey(forUser);
        } else {
            return delegate.documentEncryptionSecretKey(forUser);
        }
    }

    @Override
    public Map<String, Key> keysByIds(UserIDAuth forUser, Set<String> keyIds) {
        if (null == delegate) {
            return super.keysByIds(forUser, keyIds);
        } else {
            return delegate.keysByIds(forUser, keyIds);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DFSPrivateKeyServiceImpl> ctorCaptor) {
        context.override(DFSPrivateKeyServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final KeyStoreOperations keyStoreOper;

        private ArgumentsCaptor(KeyStoreOperations keyStoreOper) {
            this.keyStoreOper = keyStoreOper;
        }

        public KeyStoreOperations getKeyStoreOper() {
            return keyStoreOper;
        }
    }
}
