/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.KeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRegistrationService;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class ProfileRegistrationServiceImpl
implements ProfileRegistrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileRegistrationServiceImpl.class);
    private final KeyStoreOperations keyStoreOper;
    private final BucketAccessService access;
    private final StorageCheckService checkService;
    private final StorageWriteService writeService;
    private final GsonSerde serde;
    private final DFSConfig dfsConfig;

    @Inject
    public ProfileRegistrationServiceImpl(KeyStoreOperations keyStoreOper, BucketAccessService access, StorageCheckService checkService, StorageWriteService writeService, GsonSerde serde, DFSConfig dfsConfig) {
        this.keyStoreOper = keyStoreOper;
        this.access = access;
        this.checkService = checkService;
        this.writeService = writeService;
        this.serde = serde;
        this.dfsConfig = dfsConfig;
    }

    public void registerPublic(CreateUserPublicProfile profile) {
        log.debug("Register public {}", (Object)profile);
        try (OutputStream os = this.writeService.write(WithCallback.noCallback((Object)this.access.withSystemAccess(this.dfsConfig.publicProfile(profile.getId()))));){
            os.write(this.serde.toJson(profile.removeAccess()).getBytes());
        }
    }

    public void registerPrivate(CreateUserPrivateProfile profile) {
        log.debug("Register private {}", (Object)profile);
        try (OutputStream os = this.writeService.write(WithCallback.noCallback((Object)this.access.withSystemAccess(this.dfsConfig.privateProfile(profile.getId().getUserID()))));){
            os.write(this.serde.toJson(profile.removeAccess()).getBytes());
        }
        if (this.checkService.objectExists(this.access.withSystemAccess(profile.getKeystore()))) {
            log.warn("Keystore already exists for {} at {}, will not create new", (Object)profile.getId().getUserID(), (Object)profile.getKeystore().location());
            return;
        }
        this.publishPublicKeysIfNeeded(profile.getPublishPubKeysTo(), this.keyStoreOper.createAndWriteKeyStore(profile.getId()));
    }

    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        this.keyStoreOper.updateReadKeyPassword(forUser, newPassword);
    }

    public void registerUsingDefaults(UserIDAuth user) {
        this.registerPublic(this.dfsConfig.defaultPublicTemplate(user));
        this.registerPrivate(this.dfsConfig.defaultPrivateTemplate(user));
    }

    private void publishPublicKeysIfNeeded(AbsoluteLocation publishTo, List<PublicKeyIDWithPublicKey> publicKeys) {
        block16: {
            if (null != publishTo && !this.checkService.objectExists(this.access.withSystemAccess(publishTo))) {
                try (OutputStream os = this.writeService.write(WithCallback.noCallback((Object)this.access.withSystemAccess(publishTo)));){
                    os.write(this.serde.toJson(publicKeys).getBytes());
                }
                log.debug("Public keys for published {}", (Object)publishTo);
                break block16;
            }
            log.warn("Public keys already exist, won't publish {}", publicKeys);
        }
    }
}

