/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.profile.keys.KeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import java.security.Key;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.inject.Inject;

@RuntimeDelegate
public class DFSPrivateKeyServiceImpl
implements PrivateKeyService {
    private final KeyStoreOperations keyStoreOper;

    @Inject
    public DFSPrivateKeyServiceImpl(KeyStoreOperations keyStoreOper) {
        this.keyStoreOper = keyStoreOper;
    }

    public SecretKeyIDWithKey pathEncryptionSecretKey(UserIDAuth forUser) {
        return this.keyByPrefix(forUser, "PATH_SECRET");
    }

    public SecretKeyIDWithKey documentEncryptionSecretKey(UserIDAuth forUser) {
        return this.keyByPrefix(forUser, "PRIVATE_SECRET");
    }

    public Map<String, Key> keysByIds(UserIDAuth forUser, Set<String> keyIds) {
        Set aliases = this.keyStoreOper.readAliases(forUser);
        return keyIds.stream().filter(aliases::contains).collect(Collectors.toMap(keyId -> keyId, keyId -> this.keyStoreOper.getKey(forUser, keyId)));
    }

    private SecretKeyIDWithKey keyByPrefix(UserIDAuth forUser, String prefix) {
        KeyID key = this.keyStoreOper.readAliases(forUser).stream().filter(it -> it.startsWith(prefix)).map(KeyID::new).findFirst().orElseThrow(() -> new IllegalArgumentException("No key with prefix: " + prefix));
        return new SecretKeyIDWithKey(key, (SecretKey)this.keyStoreOper.getKey(forUser, key.getValue()));
    }
}

