/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRemovalService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.exceptions.UserNotFoundException;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.storage.api.actions.StorageRemoveService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import java.util.stream.Stream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class ProfileRemovalServiceImpl
implements ProfileRemovalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileRemovalServiceImpl.class);
    private final StorageListService listService;
    private final BucketAccessService access;
    private final DFSConfig dfsConfig;
    private final StorageRemoveService removeService;
    private final ProfileRetrievalService retrievalService;

    @Inject
    ProfileRemovalServiceImpl(StorageListService listService, BucketAccessService access, DFSConfig dfsConfig, StorageRemoveService removeService, ProfileRetrievalService retrievalService) {
        this.listService = listService;
        this.access = access;
        this.dfsConfig = dfsConfig;
        this.removeService = removeService;
        this.retrievalService = retrievalService;
    }

    public void deregister(UserIDAuth userID) {
        if (!this.retrievalService.userExists(userID.getUserID())) {
            log.debug("User deregistation failed. User '{}' does not exist", (Object)userID);
            throw new UserNotFoundException("User not found: " + userID);
        }
        UserPublicProfile publicProfile = this.retrievalService.publicProfile(userID.getUserID());
        UserPrivateProfile privateProfile = this.retrievalService.privateProfile(userID);
        this.removeAllIn(userID, (AbsoluteLocation<PrivateResource>)privateProfile.getPrivateStorage());
        this.removeAllIn(userID, (AbsoluteLocation<PrivateResource>)privateProfile.getInboxWithFullAccess());
        this.removeAllIn(userID, (AbsoluteLocation<PrivateResource>)privateProfile.getDocumentVersionStorage());
        Stream.of((PrivateResource)privateProfile.getKeystore().getResource(), (PrivateResource)privateProfile.getPrivateStorage().getResource(), (PrivateResource)privateProfile.getInboxWithFullAccess().getResource(), (PrivateResource)privateProfile.getDocumentVersionStorage().getResource()).map(it -> this.access.privateAccessFor(userID, it)).forEach(arg_0 -> ((StorageRemoveService)this.removeService).remove(arg_0));
        this.removeService.remove(this.access.withSystemAccess(publicProfile.getPublicKeys()));
        this.removeService.remove(this.access.withSystemAccess(this.dfsConfig.privateProfile(userID.getUserID())));
        this.removeService.remove(this.access.withSystemAccess(this.dfsConfig.publicProfile(userID.getUserID())));
        privateProfile.getAssociatedResources().stream().map(it -> this.access.privateAccessFor(userID, (PrivateResource)it.getResource())).forEach(arg_0 -> ((StorageRemoveService)this.removeService).remove(arg_0));
        log.debug("Deregistered user {}", (Object)userID);
    }

    private void removeAllIn(UserIDAuth userID, AbsoluteLocation<PrivateResource> location) {
        this.listService.list((AbsoluteLocation)new ListRequest((Object)userID, (ResourceLocation)this.access.privateAccessFor(userID, (PrivateResource)location.getResource())).getLocation()).forEach(arg_0 -> ((StorageRemoveService)this.removeService).remove(arg_0));
    }
}

