/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRegistrationServiceImpl;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class ProfileRegistrationServiceImplRuntimeDelegatable
extends ProfileRegistrationServiceImpl {
    private final ProfileRegistrationServiceImpl delegate;

    @Inject
    public ProfileRegistrationServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context, KeyStoreService keyStoreService, BucketAccessService access, StorageCheckService checkService, StorageWriteService writeService, GsonSerde serde, DFSConfig dfsConfig) {
        super(keyStoreService, access, checkService, writeService, serde, dfsConfig);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keyStoreService, access, checkService, writeService, serde, dfsConfig);
        this.delegate = context != null ? (ProfileRegistrationServiceImpl)context.findOverride(ProfileRegistrationServiceImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public void registerPublic(CreateUserPublicProfile profile) {
        if (null == this.delegate) {
            super.registerPublic(profile);
        } else {
            this.delegate.registerPublic(profile);
        }
    }

    @Override
    public void registerPrivate(CreateUserPrivateProfile profile) {
        if (null == this.delegate) {
            super.registerPrivate(profile);
        } else {
            this.delegate.registerPrivate(profile);
        }
    }

    @Override
    public void registerUsingDefaults(UserIDAuth user) {
        if (null == this.delegate) {
            super.registerUsingDefaults(user);
        } else {
            this.delegate.registerUsingDefaults(user);
        }
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, ProfileRegistrationServiceImpl> ctorCaptor) {
        context.override(ProfileRegistrationServiceImpl.class, args -> (ProfileRegistrationServiceImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final KeyStoreService keyStoreService;
        private final BucketAccessService access;
        private final StorageCheckService checkService;
        private final StorageWriteService writeService;
        private final GsonSerde serde;
        private final DFSConfig dfsConfig;

        private ArgumentsCaptor(KeyStoreService keyStoreService, BucketAccessService access, StorageCheckService checkService, StorageWriteService writeService, GsonSerde serde, DFSConfig dfsConfig) {
            this.keyStoreService = keyStoreService;
            this.access = access;
            this.checkService = checkService;
            this.writeService = writeService;
            this.serde = serde;
            this.dfsConfig = dfsConfig;
        }

        public KeyStoreService getKeyStoreService() {
            return this.keyStoreService;
        }

        public BucketAccessService getAccess() {
            return this.access;
        }

        public StorageCheckService getCheckService() {
            return this.checkService;
        }

        public StorageWriteService getWriteService() {
            return this.writeService;
        }

        public GsonSerde getSerde() {
            return this.serde;
        }

        public DFSConfig getDfsConfig() {
            return this.dfsConfig;
        }
    }
}

