/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPrivateKeyServiceImpl;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.security.Key;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class DFSPrivateKeyServiceImplRuntimeDelegatable
extends DFSPrivateKeyServiceImpl {
    private final DFSPrivateKeyServiceImpl delegate;

    @Inject
    public DFSPrivateKeyServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context, KeyStoreCache keystoreCache, KeyStoreService keyStoreService, DFSConfig dfsConfig, BucketAccessService bucketAccessService, ProfileRetrievalService profile, StorageReadService readService) {
        super(keystoreCache, keyStoreService, dfsConfig, bucketAccessService, profile, readService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keystoreCache, keyStoreService, dfsConfig, bucketAccessService, profile, readService);
        this.delegate = context != null ? (DFSPrivateKeyServiceImpl)context.findOverride(DFSPrivateKeyServiceImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public SecretKeyIDWithKey pathEncryptionSecretKey(UserIDAuth forUser) {
        if (null == this.delegate) {
            return super.pathEncryptionSecretKey(forUser);
        }
        return this.delegate.pathEncryptionSecretKey(forUser);
    }

    @Override
    public SecretKeyIDWithKey documentEncryptionSecretKey(UserIDAuth forUser) {
        if (null == this.delegate) {
            return super.documentEncryptionSecretKey(forUser);
        }
        return this.delegate.documentEncryptionSecretKey(forUser);
    }

    @Override
    public Map<String, Key> keysByIds(UserIDAuth forUser, Set<String> keyIds) {
        if (null == this.delegate) {
            return super.keysByIds(forUser, keyIds);
        }
        return this.delegate.keysByIds(forUser, keyIds);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, DFSPrivateKeyServiceImpl> ctorCaptor) {
        context.override(DFSPrivateKeyServiceImpl.class, args -> (DFSPrivateKeyServiceImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final KeyStoreCache keystoreCache;
        private final KeyStoreService keyStoreService;
        private final DFSConfig dfsConfig;
        private final BucketAccessService bucketAccessService;
        private final ProfileRetrievalService profile;
        private final StorageReadService readService;

        private ArgumentsCaptor(KeyStoreCache keystoreCache, KeyStoreService keyStoreService, DFSConfig dfsConfig, BucketAccessService bucketAccessService, ProfileRetrievalService profile, StorageReadService readService) {
            this.keystoreCache = keystoreCache;
            this.keyStoreService = keyStoreService;
            this.dfsConfig = dfsConfig;
            this.bucketAccessService = bucketAccessService;
            this.profile = profile;
            this.readService = readService;
        }

        public KeyStoreCache getKeystoreCache() {
            return this.keystoreCache;
        }

        public KeyStoreService getKeyStoreService() {
            return this.keyStoreService;
        }

        public DFSConfig getDfsConfig() {
            return this.dfsConfig;
        }

        public BucketAccessService getBucketAccessService() {
            return this.bucketAccessService;
        }

        public ProfileRetrievalService getProfile() {
            return this.profile;
        }

        public StorageReadService getReadService() {
            return this.readService;
        }
    }
}

