/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.inject.Inject;

@RuntimeDelegate
public class DFSPrivateKeyServiceImpl
implements PrivateKeyService {
    private final KeyStoreCache keystoreCache;
    private final KeyStoreService keyStoreService;
    private final DFSConfig dfsConfig;
    private final BucketAccessService bucketAccessService;
    private final ProfileRetrievalService profile;
    private final StorageReadService readService;

    @Inject
    public DFSPrivateKeyServiceImpl(KeyStoreCache keystoreCache, KeyStoreService keyStoreService, DFSConfig dfsConfig, BucketAccessService bucketAccessService, ProfileRetrievalService profile, StorageReadService readService) {
        this.keystoreCache = keystoreCache;
        this.keyStoreService = keyStoreService;
        this.dfsConfig = dfsConfig;
        this.bucketAccessService = bucketAccessService;
        this.profile = profile;
        this.readService = readService;
    }

    public SecretKeyIDWithKey pathEncryptionSecretKey(UserIDAuth forUser) {
        return this.keyByPrefix(forUser, "PATH_SECRET");
    }

    public SecretKeyIDWithKey documentEncryptionSecretKey(UserIDAuth forUser) {
        return this.keyByPrefix(forUser, "PRIVATE_SECRET");
    }

    public Map<String, Key> keysByIds(UserIDAuth forUser, Set<String> keyIds) {
        KeyStore keyStore = this.keyStore(forUser);
        Set<String> aliases = this.readAliases(keyStore);
        return keyIds.stream().filter(aliases::contains).collect(Collectors.toMap(keyId -> keyId, keyId -> this.getKey(keyStore, (String)keyId, forUser.getReadKeyPassword())));
    }

    private SecretKeyIDWithKey keyByPrefix(UserIDAuth forUser, String prefix) {
        KeyStore keyStore = this.keyStore(forUser);
        KeyID key = this.readAliases(keyStore).stream().filter(it -> it.startsWith(prefix)).map(KeyID::new).findFirst().orElseThrow(() -> new IllegalArgumentException("No key with prefix: " + prefix));
        return new SecretKeyIDWithKey(key, (SecretKey)this.getKey(keyStore, key.getValue(), forUser.getReadKeyPassword()));
    }

    private KeyStore keyStore(UserIDAuth forUser) {
        return this.keystoreCache.getKeystore().computeIfAbsent(forUser.getUserID(), userId -> this.readKeyStore(forUser));
    }

    private KeyStore readKeyStore(UserIDAuth forUser) {
        byte[] payload;
        AbsoluteLocation access = this.bucketAccessService.privateAccessFor(forUser, (PrivateResource)this.profile.privateProfile(forUser).getKeystore().getResource());
        try (InputStream is = this.readService.read(access);){
            payload = ByteStreams.toByteArray((InputStream)is);
        }
        return this.keyStoreService.deserialize(payload, forUser.getUserID().getValue(), this.dfsConfig.privateKeyStoreAuth(forUser).getReadStorePassword());
    }

    private Key getKey(KeyStore keyStore, String alias, ReadKeyPassword readKeyPassword) {
        return keyStore.getKey(alias, readKeyPassword.getValue().toCharArray());
    }

    private Set<String> readAliases(KeyStore keyStore) {
        HashSet<String> result = new HashSet<String>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            result.add(aliases.nextElement());
        }
        return result;
    }
}

