package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.lang.String;
import java.security.Key;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DFSPrivateKeyServiceImplRuntimeDelegatable extends DFSPrivateKeyServiceImpl {
    private final DFSPrivateKeyServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DFSPrivateKeyServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            KeyStoreCache keystoreCache, KeyStoreService keyStoreService, DFSConfig dfsConfig,
            BucketAccessService bucketAccessService, ProfileRetrievalService profile,
            StorageReadService readService) {
        super(keystoreCache, keyStoreService, dfsConfig, bucketAccessService, profile, readService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keystoreCache, keyStoreService, dfsConfig, bucketAccessService, profile, readService);
        delegate = context != null ? context.findOverride(DFSPrivateKeyServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public SecretKeyIDWithKey pathEncryptionSecretKey(UserIDAuth forUser) {
        if (null == delegate) {
            return super.pathEncryptionSecretKey(forUser);
        } else {
            return delegate.pathEncryptionSecretKey(forUser);
        }
    }

    @Override
    public SecretKeyIDWithKey documentEncryptionSecretKey(UserIDAuth forUser) {
        if (null == delegate) {
            return super.documentEncryptionSecretKey(forUser);
        } else {
            return delegate.documentEncryptionSecretKey(forUser);
        }
    }

    @Override
    public Map<String, Key> keysByIds(UserIDAuth forUser, Set<String> keyIds) {
        if (null == delegate) {
            return super.keysByIds(forUser, keyIds);
        } else {
            return delegate.keysByIds(forUser, keyIds);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DFSPrivateKeyServiceImpl> ctorCaptor) {
        context.override(DFSPrivateKeyServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final KeyStoreCache keystoreCache;

        private final KeyStoreService keyStoreService;

        private final DFSConfig dfsConfig;

        private final BucketAccessService bucketAccessService;

        private final ProfileRetrievalService profile;

        private final StorageReadService readService;

        private ArgumentsCaptor(KeyStoreCache keystoreCache, KeyStoreService keyStoreService,
                DFSConfig dfsConfig, BucketAccessService bucketAccessService,
                ProfileRetrievalService profile, StorageReadService readService) {
            this.keystoreCache = keystoreCache;
            this.keyStoreService = keyStoreService;
            this.dfsConfig = dfsConfig;
            this.bucketAccessService = bucketAccessService;
            this.profile = profile;
            this.readService = readService;
        }

        public KeyStoreCache getKeystoreCache() {
            return keystoreCache;
        }

        public KeyStoreService getKeyStoreService() {
            return keyStoreService;
        }

        public DFSConfig getDfsConfig() {
            return dfsConfig;
        }

        public BucketAccessService getBucketAccessService() {
            return bucketAccessService;
        }

        public ProfileRetrievalService getProfile() {
            return profile;
        }

        public StorageReadService getReadService() {
            return readService;
        }
    }
}
