/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.serde;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Excluder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.adorsys.datasafe.encrypiton.api.keystore.PublicKeySerde;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BasePublicResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.PublicKey;
import javax.inject.Inject;
import lombok.Generated;

public class GsonSerde {
    private final Gson gson;

    @Inject
    public GsonSerde(PublicKeySerde pubSerde) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(PublicResource.class, (elem, type, ctx) -> new BasePublicResource(URI.create(elem.getAsString())));
        gsonBuilder.registerTypeAdapter(PublicKey.class, (elem, type, ctx) -> pubSerde.readPubKey(elem.getAsString()));
        gsonBuilder.registerTypeAdapter(PrivateResource.class, (elem, type, ctx) -> new BasePrivateResource(URI.create(elem.getAsString())));
        gsonBuilder.registerTypeAdapter(PublicResource.class, (elem, type, ctx) -> new JsonPrimitive(elem.location().toString()));
        gsonBuilder.registerTypeAdapter(PrivateResource.class, (elem, type, ctx) -> new JsonPrimitive(elem.location().toString()));
        gsonBuilder.registerTypeAdapter(PublicKey.class, (elem, type, ctx) -> new JsonPrimitive(pubSerde.writePubKey(elem)));
        this.gson = gsonBuilder.create();
    }

    @Generated
    public GsonBuilder newBuilder() {
        return this.gson.newBuilder();
    }

    @Generated
    public Excluder excluder() {
        return this.gson.excluder();
    }

    @Generated
    public FieldNamingStrategy fieldNamingStrategy() {
        return this.gson.fieldNamingStrategy();
    }

    @Generated
    public boolean serializeNulls() {
        return this.gson.serializeNulls();
    }

    @Generated
    public boolean htmlSafe() {
        return this.gson.htmlSafe();
    }

    @Generated
    public <T> TypeAdapter<T> getAdapter(TypeToken<T> type) {
        return this.gson.getAdapter(type);
    }

    @Generated
    public <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory skipPast, TypeToken<T> type) {
        return this.gson.getDelegateAdapter(skipPast, type);
    }

    @Generated
    public <T> TypeAdapter<T> getAdapter(Class<T> type) {
        return this.gson.getAdapter(type);
    }

    @Generated
    public JsonElement toJsonTree(Object src) {
        return this.gson.toJsonTree(src);
    }

    @Generated
    public JsonElement toJsonTree(Object src, Type typeOfSrc) {
        return this.gson.toJsonTree(src, typeOfSrc);
    }

    @Generated
    public String toJson(Object src) {
        return this.gson.toJson(src);
    }

    @Generated
    public String toJson(Object src, Type typeOfSrc) {
        return this.gson.toJson(src, typeOfSrc);
    }

    @Generated
    public void toJson(Object src, Appendable writer) throws JsonIOException {
        this.gson.toJson(src, writer);
    }

    @Generated
    public void toJson(Object src, Type typeOfSrc, Appendable writer) throws JsonIOException {
        this.gson.toJson(src, typeOfSrc, writer);
    }

    @Generated
    public void toJson(Object src, Type typeOfSrc, JsonWriter writer) throws JsonIOException {
        this.gson.toJson(src, typeOfSrc, writer);
    }

    @Generated
    public String toJson(JsonElement jsonElement) {
        return this.gson.toJson(jsonElement);
    }

    @Generated
    public void toJson(JsonElement jsonElement, Appendable writer) throws JsonIOException {
        this.gson.toJson(jsonElement, writer);
    }

    @Generated
    public JsonWriter newJsonWriter(Writer writer) throws IOException {
        return this.gson.newJsonWriter(writer);
    }

    @Generated
    public JsonReader newJsonReader(Reader reader) {
        return this.gson.newJsonReader(reader);
    }

    @Generated
    public void toJson(JsonElement jsonElement, JsonWriter writer) throws JsonIOException {
        this.gson.toJson(jsonElement, writer);
    }

    @Generated
    public <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        return (T)this.gson.fromJson(json, classOfT);
    }

    @Generated
    public <T> T fromJson(String json, Type typeOfT) throws JsonSyntaxException {
        return (T)this.gson.fromJson(json, typeOfT);
    }

    @Generated
    public <T> T fromJson(Reader json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)this.gson.fromJson(json, classOfT);
    }

    @Generated
    public <T> T fromJson(Reader json, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        return (T)this.gson.fromJson(json, typeOfT);
    }

    @Generated
    public <T> T fromJson(JsonReader reader, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        return (T)this.gson.fromJson(reader, typeOfT);
    }

    @Generated
    public <T> T fromJson(JsonElement json, Class<T> classOfT) throws JsonSyntaxException {
        return (T)this.gson.fromJson(json, classOfT);
    }

    @Generated
    public <T> T fromJson(JsonElement json, Type typeOfT) throws JsonSyntaxException {
        return (T)this.gson.fromJson(json, typeOfT);
    }
}

