/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePublicResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import javax.inject.Inject;

public class DFSSystem {
    private final DFSConfig config;

    @Inject
    public DFSSystem(DFSConfig config) {
        this.config = config;
    }

    public ReadStorePassword systemKeystoreAuth() {
        return new ReadStorePassword(this.config.keystorePassword());
    }

    public KeyStoreAuth privateKeyStoreAuth(UserIDAuth auth) {
        return new KeyStoreAuth(new ReadStorePassword(this.config.keystorePassword()), auth.getReadKeyPassword());
    }

    public KeyStoreAuth publicKeyStoreAuth() {
        return new KeyStoreAuth(new ReadStorePassword(this.config.keystorePassword()), new ReadKeyPassword(this.config.keystorePassword()));
    }

    public AbsoluteLocation<PublicResource> dfsRoot() {
        return new AbsoluteLocation((ResourceLocation)new BasePublicResource(this.config.systemRoot()));
    }
}

