/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.operations;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRegistrationService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRemovalService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.exceptions.UserNotFoundException;
import de.adorsys.datasafe.directory.impl.profile.operations.DFSSystem;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAccess;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.storage.api.actions.StorageRemoveService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BasePublicResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.List;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSBasedProfileStorageImpl
implements ProfileRegistrationService,
ProfileRetrievalService,
ProfileRemovalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DFSBasedProfileStorageImpl.class);
    private static final URI PRIVATE = URI.create("./profiles/private/");
    private static final URI PUBLIC = URI.create("./profiles/public/");
    private final StorageReadService readService;
    private final StorageWriteService writeService;
    private final StorageRemoveService removeService;
    private final StorageListService listService;
    private final StorageCheckService checkService;
    private final KeyStoreService keyStoreService;
    private final DFSSystem dfsSystem;
    private final GsonSerde serde;
    private final UserProfileCache userProfileCache;

    @Inject
    public DFSBasedProfileStorageImpl(StorageReadService readService, StorageWriteService writeService, StorageRemoveService removeService, StorageListService listService, StorageCheckService checkService, KeyStoreService keyStoreService, DFSSystem dfsSystem, GsonSerde serde, UserProfileCache userProfileCache) {
        this.readService = readService;
        this.writeService = writeService;
        this.removeService = removeService;
        this.listService = listService;
        this.checkService = checkService;
        this.keyStoreService = keyStoreService;
        this.dfsSystem = dfsSystem;
        this.serde = serde;
        this.userProfileCache = userProfileCache;
    }

    public void registerPublic(CreateUserPublicProfile profile) {
        try (OutputStream os = this.writeService.write(this.locatePublicProfile(profile.getId()));){
            os.write(this.serde.toJson(profile.removeAccess()).getBytes());
        }
        log.debug("Register public {}", (Object)profile.getId());
    }

    public void registerPrivate(CreateUserPrivateProfile profile) {
        try (OutputStream os = this.writeService.write(this.locatePrivateProfile(profile.getId().getUserID()));){
            os.write(this.serde.toJson(profile.removeAccess()).getBytes());
        }
        log.debug("Register private {}", (Object)profile.getId());
        if (this.checkService.objectExists(profile.getKeystore())) {
            return;
        }
        List<PublicKeyIDWithPublicKey> publicKeys = this.createKeyStore(profile.getId().getUserID(), this.dfsSystem.privateKeyStoreAuth(profile.getId()), profile.getKeystore());
        this.publishPublicKeysIfNeeded(profile.getPublishPubKeysTo(), publicKeys);
    }

    public void deregister(UserIDAuth userID) {
        if (!this.userExists(userID.getUserID())) {
            log.debug("User deregistation failed. User '{}' does not exist", (Object)userID);
            throw new UserNotFoundException("User not found: " + userID);
        }
        AbsoluteLocation privateStorage = this.privateProfile(userID).getPrivateStorage();
        this.removeStorageByLocation(userID, (AbsoluteLocation<PrivateResource>)privateStorage);
        AbsoluteLocation inbox = this.privateProfile(userID).getInboxWithFullAccess();
        this.removeStorageByLocation(userID, (AbsoluteLocation<PrivateResource>)inbox);
        this.removeService.remove(this.privateProfile(userID).getKeystore());
        this.removeService.remove(privateStorage);
        this.removeService.remove(inbox);
        this.removeService.remove(this.locatePrivateProfile(userID.getUserID()));
        this.removeService.remove(this.locatePublicProfile(userID.getUserID()));
        log.debug("Deregistered user {}", (Object)userID);
    }

    private void removeStorageByLocation(UserIDAuth userID, AbsoluteLocation<PrivateResource> privateStorage) {
        this.listService.list((AbsoluteLocation)new ListRequest((Object)userID, privateStorage).getLocation()).forEach(arg_0 -> ((StorageRemoveService)this.removeService).remove(arg_0));
    }

    public UserPublicProfile publicProfile(UserID ofUser) {
        UserPublicProfile userPublicProfile = this.userProfileCache.getPublicProfile().computeIfAbsent(ofUser, id -> this.readProfile(this.locatePublicProfile(ofUser), UserPublicProfile.class));
        log.debug("get public profile {} for user {}", (Object)userPublicProfile, (Object)ofUser);
        return userPublicProfile;
    }

    public UserPrivateProfile privateProfile(UserIDAuth ofUser) {
        UserPrivateProfile userPrivateProfile = this.userProfileCache.getPrivateProfile().computeIfAbsent(ofUser.getUserID(), id -> this.readProfile(this.locatePrivateProfile(ofUser.getUserID()), UserPrivateProfile.class));
        log.debug("get private profile {} for user {}", (Object)userPrivateProfile, (Object)ofUser);
        return userPrivateProfile;
    }

    public boolean userExists(UserID ofUser) {
        return this.checkService.objectExists(this.locatePrivateProfile(ofUser)) && this.checkService.objectExists(this.locatePublicProfile(ofUser));
    }

    private <T extends ResourceLocation<T>> List<PublicKeyIDWithPublicKey> createKeyStore(UserID forUser, KeyStoreAuth auth, AbsoluteLocation<T> keystore) {
        KeyStore keystoreBlob = this.keyStoreService.createKeyStore(auth, KeyStoreType.DEFAULT, new KeyStoreCreationConfig(1, 1));
        try (OutputStream os = this.writeService.write(keystore);){
            os.write(this.keyStoreService.serialize(keystoreBlob, forUser.getValue(), auth.getReadStorePassword()));
        }
        log.debug("Keystore created for user {} in path {}", (Object)forUser, keystore);
        return this.keyStoreService.getPublicKeys(new KeyStoreAccess(keystoreBlob, auth));
    }

    private void publishPublicKeysIfNeeded(AbsoluteLocation publishTo, List<PublicKeyIDWithPublicKey> publicKeys) {
        block14: {
            if (null == publishTo || this.checkService.objectExists(publishTo)) break block14;
            try (OutputStream os = this.writeService.write(publishTo);){
                os.write(this.serde.toJson(publicKeys).getBytes());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readProfile(AbsoluteLocation resource, Class<T> clazz) {
        try (InputStream is = this.readService.read(resource);){
            log.debug("read profile {}", (Object)resource.location().getPath());
            T t = this.serde.fromJson(new String(ByteStreams.toByteArray((InputStream)is)), clazz);
            return t;
        }
    }

    private AbsoluteLocation<PrivateResource> locatePrivateProfile(UserID ofUser) {
        return new AbsoluteLocation((ResourceLocation)new BasePrivateResource(PRIVATE.resolve(ofUser.getValue())).resolve(this.dfsSystem.dfsRoot()));
    }

    private AbsoluteLocation<PublicResource> locatePublicProfile(UserID ofUser) {
        return new AbsoluteLocation((ResourceLocation)new BasePublicResource(PUBLIC.resolve(ofUser.getValue())).resolve(this.dfsSystem.dfsRoot()));
    }
}

