/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.keys.StreamReadUtil;
import de.adorsys.datasafe.directory.impl.profile.operations.DFSSystem;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.SecretKey;
import javax.inject.Inject;

public class DFSPrivateKeyServiceImpl
implements PrivateKeyService {
    private final KeyStoreCache keystoreCache;
    private final KeyStoreService keyStoreService;
    private final DFSSystem dfsSystem;
    private final BucketAccessService bucketAccessService;
    private final ProfileRetrievalService profile;
    private final StreamReadUtil streamReadUtil;
    private final StorageReadService readService;

    @Inject
    public DFSPrivateKeyServiceImpl(KeyStoreCache keystoreCache, KeyStoreService keyStoreService, DFSSystem dfsSystem, BucketAccessService bucketAccessService, ProfileRetrievalService profile, StreamReadUtil streamReadUtil, StorageReadService readService) {
        this.keystoreCache = keystoreCache;
        this.keyStoreService = keyStoreService;
        this.dfsSystem = dfsSystem;
        this.bucketAccessService = bucketAccessService;
        this.profile = profile;
        this.streamReadUtil = streamReadUtil;
        this.readService = readService;
    }

    public SecretKeyIDWithKey pathEncryptionSecretKey(UserIDAuth forUser) {
        return new SecretKeyIDWithKey(KeyStoreCreationConfig.PATH_KEY_ID, (SecretKey)this.keyById(forUser, KeyStoreCreationConfig.PATH_KEY_ID.getValue()));
    }

    public SecretKeyIDWithKey documentEncryptionSecretKey(UserIDAuth forUser) {
        return new SecretKeyIDWithKey(KeyStoreCreationConfig.SYMM_KEY_ID, (SecretKey)this.keyById(forUser, KeyStoreCreationConfig.SYMM_KEY_ID.getValue()));
    }

    public Key keyById(UserIDAuth forUser, String keyId) {
        KeyStore keyStore = this.keystoreCache.getPrivateKeys().computeIfAbsent(forUser.getUserID(), userId -> this.keystore(forUser));
        return keyStore.getKey(keyId, forUser.getReadKeyPassword().getValue().toCharArray());
    }

    private KeyStore keystore(UserIDAuth forUser) {
        AbsoluteLocation access = this.bucketAccessService.privateAccessFor(forUser, (ResourceLocation)this.profile.privateProfile(forUser).getKeystore());
        byte[] payload = this.streamReadUtil.readStream(this.readService.read(access));
        return this.keyStoreService.deserialize(payload, forUser.getUserID().getValue(), this.dfsSystem.systemKeystoreAuth());
    }
}

