/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.hacks.graalfeature;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class GraalCompileFixNpeOnMissingServiceTypeInKnownProviders
implements Feature {
    private static final String PROVIDER_ACCESS_LOGGER = "PROVIDER_ACCESS_LOGGER";

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try (InputStream is = classloader.getResourceAsStream("extra_engines.hack");
             InputStreamReader streamReader = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            reader.lines().forEach(it -> {
                System.out.println("Overriding " + it);
                String[] typeAndValue = it.split("=");
                String[] params = typeAndValue[1].split(",");
                this.addEngine(typeAndValue[0], params[0], params[1]);
            });
        }
        catch (IOException ex) {
            System.out.println("Failed to read resource - extra_engines.hack " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void addEngine(String name, String sp, String paramNam) {
        try {
            this.addEngineInternal(name, sp, paramNam);
        }
        catch (ReflectiveOperationException ex) {
            System.out.println("Reflective access error " + ex.getMessage());
            ex.printStackTrace();
            throw new IllegalStateException("Failed");
        }
    }

    private void addEngineInternal(String name, String sp, String paramNam) throws NoSuchFieldException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Field knownEngines = Provider.class.getDeclaredField("knownEngines");
        knownEngines.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(knownEngines, knownEngines.getModifiers() & 0xFFFFFFEF);
        Class<?> engineDescription = Class.forName("java.security.Provider$EngineDescription");
        Constructor<?> ctor = engineDescription.getDeclaredConstructor(String.class, Boolean.TYPE, String.class);
        ctor.setAccessible(true);
        Map<String, Object> originalEngine = (Map<String, Object>)knownEngines.get(null);
        Map<String, Object> delegate = null != System.getProperty(PROVIDER_ACCESS_LOGGER) ? new EngineDelegate(originalEngine) : originalEngine;
        knownEngines.set(Map.class, delegate);
        Object engineDescInstance = ctor.newInstance(name, Boolean.parseBoolean(sp), "null".equals(paramNam) ? null : paramNam);
        delegate.put(name.toLowerCase(Locale.ENGLISH), engineDescInstance);
        delegate.put(name, engineDescInstance);
    }

    private static class EngineDelegate
    implements Map<String, Object> {
        private final Map<String, Object> delegate;

        @Override
        public Object get(Object key) {
            Object value = this.delegate.get(key);
            if (null == value) {
                System.out.println("Detected access to null value in Provider.knownEngines for type " + key);
            }
            return value;
        }

        @Generated
        public EngineDelegate(Map<String, Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        @Generated
        public int size() {
            return this.delegate.size();
        }

        @Override
        @Generated
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        @Generated
        public boolean containsKey(Object arg0) {
            return this.delegate.containsKey(arg0);
        }

        @Override
        @Generated
        public boolean containsValue(Object arg0) {
            return this.delegate.containsValue(arg0);
        }

        @Override
        @Generated
        public Object put(String arg0, Object arg1) {
            return this.delegate.put(arg0, arg1);
        }

        @Override
        @Generated
        public Object remove(Object arg0) {
            return this.delegate.remove(arg0);
        }

        @Override
        @Generated
        public void putAll(Map<? extends String, ?> arg0) {
            this.delegate.putAll(arg0);
        }

        @Override
        @Generated
        public void clear() {
            this.delegate.clear();
        }

        @Override
        @Generated
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        @Generated
        public Collection<Object> values() {
            return this.delegate.values();
        }

        @Override
        @Generated
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        @Generated
        public Object getOrDefault(Object key, Object defaultValue) {
            return this.delegate.getOrDefault(key, defaultValue);
        }

        @Override
        @Generated
        public void forEach(BiConsumer<? super String, ? super Object> action) {
            this.delegate.forEach(action);
        }

        @Override
        @Generated
        public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
            this.delegate.replaceAll(function);
        }

        @Override
        @Generated
        public Object putIfAbsent(String key, Object value) {
            return this.delegate.putIfAbsent(key, value);
        }

        @Override
        @Generated
        public boolean remove(Object key, Object value) {
            return this.delegate.remove(key, value);
        }

        @Override
        @Generated
        public boolean replace(String key, Object oldValue, Object newValue) {
            return this.delegate.replace(key, oldValue, newValue);
        }

        @Override
        @Generated
        public Object replace(String key, Object value) {
            return this.delegate.replace(key, value);
        }

        @Override
        @Generated
        public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
            return this.delegate.computeIfAbsent(key, mappingFunction);
        }

        @Override
        @Generated
        public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
            return this.delegate.computeIfPresent(key, remappingFunction);
        }

        @Override
        @Generated
        public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
            return this.delegate.compute(key, remappingFunction);
        }

        @Override
        @Generated
        public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            return this.delegate.merge(key, value, remappingFunction);
        }

        private static interface Get {
            public Object get(Object var1);
        }
    }
}

