/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.commands.profile.update;

import de.adorsys.datasafe.cli.Cli;
import de.adorsys.datasafe.cli.commands.profile.InputUtil;
import de.adorsys.datasafe.cli.commands.profile.update.Update;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.util.Collections;
import lombok.Generated;
import picocli.CommandLine;

@CommandLine.Command(name="private", description={"Updates user private part of user profile"})
public class PrivateProfile
implements Runnable {
    @CommandLine.ParentCommand
    private Update update;

    @Override
    public void run() {
        Cli cli = this.update.getProfile().getCli();
        UserPrivateProfile current = cli.datasafe().userProfile().privateProfile(cli.auth());
        UserPrivateProfile privateProfile = UserPrivateProfile.builder().keystore(BasePrivateResource.forAbsolutePrivate((Uri)InputUtil.inpPath("Keystore", this.asStr(current.getKeystore())))).privateStorage(current.getPrivateStorage()).inboxWithFullAccess(BasePrivateResource.forAbsolutePrivate((Uri)InputUtil.inpPath("Inbox", this.asStr(current.getInboxWithFullAccess())))).storageCredentialsKeystore(BasePrivateResource.forAbsolutePrivate((Uri)InputUtil.inpPath("Storage credentials keystore", this.asStr(current.getStorageCredentialsKeystore())))).associatedResources(Collections.emptyList()).publishPublicKeysTo(current.getPublishPublicKeysTo()).build();
        cli.datasafe().userProfile().updatePrivateProfile(cli.auth(), privateProfile);
    }

    private String asStr(AbsoluteLocation location) {
        return location.location().asString();
    }

    @Generated
    public Update getUpdate() {
        return this.update;
    }
}

