/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.commands.profile;

import com.google.common.base.Strings;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Scanner;
import lombok.Generated;

public final class InputUtil {
    private static final Scanner SCANNER = new Scanner(System.in);

    public static String input(String text, String defaultValue) {
        String input;
        System.out.printf("%s (%s):%n", text, defaultValue);
        String string = input = SCANNER.hasNextLine() ? SCANNER.nextLine() : null;
        if (Strings.isNullOrEmpty((String)input)) {
            return defaultValue;
        }
        return input;
    }

    public static Uri inpPath(String text, String defaultValue) {
        String result = InputUtil.input(text, defaultValue);
        URI asUri = URI.create(result);
        if (asUri.isAbsolute()) {
            return new Uri(asUri);
        }
        if (result.startsWith("~/")) {
            result = result.replaceFirst("^~", System.getProperty("user.home"));
        }
        return new Uri(Paths.get(result, new String[0]).toUri());
    }

    @Generated
    private InputUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

