/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.commands.privatespace;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.cli.commands.privatespace.Privatespace;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.io.InputStream;
import java.io.OutputStream;
import picocli.CommandLine;

@CommandLine.Command(name="cat", description={"Decrypts private file contents and prints it to STDOUT"})
public class Cat
implements Runnable {
    @CommandLine.ParentCommand
    private Privatespace privatespace;
    @CommandLine.Option(names={"--storage", "-s"}, description={"Storage identifier"})
    private String storageId = "DEFAULT";
    @CommandLine.Parameters(description={"Filename to decrypt and print"}, arity="1")
    private String path;

    @Override
    public void run() {
        try (PasswordClearingInputStream is = this.privatespace.getCli().datasafe().privateService().read(ReadRequest.forPrivate((Object)this.privatespace.getCli().auth(), (StorageIdentifier)new StorageIdentifier(this.storageId), (String)this.path));){
            ByteStreams.copy((InputStream)is, (OutputStream)System.out);
        }
    }
}

