/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.commands.profile.storage;

import de.adorsys.datasafe.cli.Cli;
import de.adorsys.datasafe.cli.commands.profile.storage.Storage;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.util.HashMap;
import lombok.Generated;
import picocli.CommandLine;

@CommandLine.Command(name="remove", aliases={"rm"}, description={"Removes path access credentials"})
public class Remove
implements Runnable {
    @CommandLine.ParentCommand
    private Storage storage;
    @CommandLine.Option(names={"--identifier", "-i"}, description={"Storage identifier to be associated with this path"}, required=true)
    private String identifier;

    @Override
    public void run() {
        Cli cli = this.storage.getProfile().getCli();
        UserPrivateProfile privateProfile = cli.datasafe().userProfile().privateProfile(cli.auth());
        HashMap pathsMap = new HashMap(privateProfile.getPrivateStorage());
        pathsMap.remove(new StorageIdentifier(this.identifier));
        cli.datasafe().userProfile().updatePrivateProfile(cli.auth(), privateProfile.toBuilder().privateStorage(pathsMap).build());
    }

    @Generated
    public Storage getStorage() {
        return this.storage;
    }
}

