/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.commands.profile.update;

import de.adorsys.datasafe.cli.Cli;
import de.adorsys.datasafe.cli.commands.profile.InputUtil;
import de.adorsys.datasafe.cli.commands.profile.update.Update;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePublicResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import lombok.Generated;
import picocli.CommandLine;

@CommandLine.Command(name="public", description={"Updates user public part of user profile"})
public class PublicProfile
implements Runnable {
    @CommandLine.ParentCommand
    private Update update;

    @Override
    public void run() {
        Cli cli = this.update.getProfile().getCli();
        UserPublicProfile current = cli.datasafe().userProfile().publicProfile(cli.auth().getUserID());
        UserPublicProfile publicProfile = UserPublicProfile.builder().inbox(BasePublicResource.forAbsolutePublic((Uri)InputUtil.inpPath("Inbox", this.asStr(current.getPublicKeys())))).publicKeys(BasePublicResource.forAbsolutePublic((Uri)InputUtil.inpPath("Public keys", this.asStr(current.getInbox())))).build();
        cli.datasafe().userProfile().updatePublicProfile(cli.auth(), publicProfile);
    }

    private String asStr(AbsoluteLocation location) {
        return location.location().asString();
    }

    @Generated
    public Update getUpdate() {
        return this.update;
    }
}

