/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.commands.privatespace;

import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import de.adorsys.datasafe.cli.commands.privatespace.Privatespace;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import picocli.CommandLine;

@CommandLine.Command(name="copy", aliases={"cp"}, description={"Encrypts and copies file into your private space - only you can read it"})
public class Copy
implements Runnable {
    @CommandLine.ParentCommand
    private Privatespace privatespace;
    @CommandLine.Option(names={"--storage", "-s"}, description={"Storage identifier"})
    private String storageId = "DEFAULT";
    @CommandLine.Parameters(description={"Path to copy from"}, index="0", arity="1")
    private Path from;
    @CommandLine.Parameters(description={"Path in privatespace to copy to"}, index="1", arity="1")
    private String to;

    @Override
    public void run() {
        try (PasswordClearingOutputStream os = this.privatespace.getCli().datasafe().privateService().write(WriteRequest.forPrivate((Object)this.privatespace.getCli().auth(), (StorageIdentifier)new StorageIdentifier(this.storageId), (String)this.to));
             InputStream is = MoreFiles.asByteSource((Path)this.from, (OpenOption[])new OpenOption[]{StandardOpenOption.READ}).openStream();){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
    }
}

