/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.commands.profile.storage;

import de.adorsys.datasafe.cli.Cli;
import de.adorsys.datasafe.cli.commands.profile.storage.Storage;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.util.HashMap;
import lombok.Generated;
import picocli.CommandLine;

@CommandLine.Command(name="add", description={"Adds private storage"})
public class Add
implements Runnable {
    @CommandLine.ParentCommand
    private Storage storage;
    @CommandLine.Option(names={"--identifier", "-i"}, description={"Storage identifier to be associated with this path"}, required=true)
    private String identifier;
    @CommandLine.Option(names={"--path", "-p"}, description={"Absolute path (with protocol) that is associated with this identifier"}, required=true)
    private String path;

    @Override
    public void run() {
        Cli cli = this.storage.getProfile().getCli();
        UserPrivateProfile privateProfile = cli.datasafe().userProfile().privateProfile(cli.auth());
        HashMap<StorageIdentifier, AbsoluteLocation> pathsMap = new HashMap<StorageIdentifier, AbsoluteLocation>(privateProfile.getPrivateStorage());
        pathsMap.put(new StorageIdentifier(this.identifier), BasePrivateResource.forAbsolutePrivate((String)this.path));
        cli.datasafe().userProfile().updatePrivateProfile(cli.auth(), privateProfile.toBuilder().privateStorage(pathsMap).build());
    }

    @Generated
    public Storage getStorage() {
        return this.storage;
    }
}

