/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.commands.profile;

import de.adorsys.datasafe.cli.commands.profile.InputUtil;
import de.adorsys.datasafe.cli.commands.profile.Profile;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BasePublicResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.util.Collections;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Creates new user profile (new user)"})
public class Create
implements Runnable {
    @CommandLine.ParentCommand
    private Profile profile;

    @Override
    public void run() {
        String user = this.profile.getCli().auth().getUserID().getValue();
        Uri publicKeys = InputUtil.inpPath("Public keys", this.atRoot(user, "pubkeys"));
        Uri inbox = InputUtil.inpPath("Your INBOX folder", this.atRoot(user, "inbox/"));
        CreateUserPublicProfile publicProfile = CreateUserPublicProfile.builder().id(this.profile.getCli().auth().getUserID()).publicKeys(BasePublicResource.forAbsolutePublic((Uri)publicKeys)).inbox(BasePublicResource.forAbsolutePublic((Uri)inbox)).build();
        this.profile.getCli().datasafe().userProfile().registerPublic(publicProfile);
        CreateUserPrivateProfile privateProfile = CreateUserPrivateProfile.builder().id(this.profile.getCli().auth()).keystore(BasePrivateResource.forAbsolutePrivate((Uri)InputUtil.inpPath("Keystore", this.atRoot(user, "keystore")))).privateStorage(BasePrivateResource.forAbsolutePrivate((Uri)InputUtil.inpPath("Private files", this.atRoot(user, "private/")))).inboxWithWriteAccess(BasePrivateResource.forAbsolutePrivate((Uri)inbox)).storageCredentialsKeystore(BasePrivateResource.forAbsolutePrivate((Uri)InputUtil.inpPath("Storage credentials keystore", this.atRoot(user, "storage.keystore")))).associatedResources(Collections.emptyList()).publishPubKeysTo(BasePublicResource.forAbsolutePublic((Uri)publicKeys)).build();
        this.profile.getCli().datasafe().userProfile().registerPrivate(privateProfile);
        this.profile.getCli().datasafe().userProfile().createAllAllowableKeystores(this.profile.getCli().auth(), privateProfile.buildPrivateProfile());
    }

    private String atRoot(String username, String name) {
        String resolved = this.profile.getCli().getProfilesRoot().resolve(username).resolve(name).toAbsolutePath().toUri().toASCIIString();
        return name.endsWith("/") && !resolved.endsWith("/") ? resolved + "/" : resolved;
    }
}

