/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli.config;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.collect.ImmutableMap;
import dagger.Lazy;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImpl;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.dfs.RegexAccessServiceWithStorageCredentialsImpl;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.RegexDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.api.UriBasedAuthStorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.storage.impl.s3.S3ClientFactory;
import de.adorsys.datasafe.storage.impl.s3.S3StorageService;
import de.adorsys.datasafe.types.api.context.BaseOverridesRegistry;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.datasafe.types.api.utils.ExecutorServiceUtil;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatasafeFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatasafeFactory.class);

    public static DefaultDatasafeServices datasafe(Path fsRoot, ReadStorePassword systemPassword) {
        BaseOverridesRegistry registry = new BaseOverridesRegistry();
        DefaultDatasafeServices multiDfsDatasafe = DaggerDefaultDatasafeServices.builder().config((DFSConfig)new DefaultDFSConfig(fsRoot.toUri(), systemPassword)).storage((StorageService)new RegexDelegatingStorage((Map)ImmutableMap.builder().put((Object)Pattern.compile("file:/.+"), (Object)DatasafeFactory.localFs(fsRoot)).put((Object)Pattern.compile("s3://.+"), (Object)DatasafeFactory.amazonS3()).put((Object)Pattern.compile("http://.+"), (Object)DatasafeFactory.httpS3()).put((Object)Pattern.compile("https://.+"), (Object)DatasafeFactory.httpS3()).build())).overridesRegistry((OverridesRegistry)registry).build();
        BucketAccessServiceImplRuntimeDelegatable.overrideWith((OverridesRegistry)registry, args -> new WithCredentialProvider(args.getStorageKeyStoreOperations()));
        return multiDfsDatasafe;
    }

    private static StorageService localFs(Path fsRoot) {
        return new FileSystemStorageService(fsRoot);
    }

    private static StorageService httpS3() {
        return new UriBasedAuthStorageService(acc -> DatasafeFactory.getStorageService(acc.getAccessKey(), acc.getSecretKey(), acc.getEndpoint(), acc.getRegion(), acc.getBucketName()));
    }

    private static StorageService amazonS3() {
        return new UriBasedAuthStorageService(acc -> new S3StorageService(S3ClientFactory.getAmazonClient((String)acc.getRegion(), (String)acc.getAccessKey(), (String)acc.getSecretKey()), acc.getBucketName(), ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService()), uri -> (uri.getHost() + "/" + uri.getPath().replaceFirst("^/", "")).split("/"));
    }

    private static S3StorageService getStorageService(String accessKey, String secretKey, String url, String region, String bucket) {
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)))).enablePathStyleAccess();
        AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(url, region);
        amazonS3ClientBuilder.withEndpointConfiguration(endpoint);
        if (!url.toLowerCase().startsWith("https")) {
            log.info("Creating S3 client without https");
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setProtocol(Protocol.HTTP);
            clientConfig.disableSocketProxy();
            amazonS3ClientBuilder.withClientConfiguration(clientConfig);
        }
        AmazonS3 amazons3 = (AmazonS3)amazonS3ClientBuilder.build();
        return new S3StorageService(amazons3, bucket, ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService((int)5, (int)5));
    }

    @Generated
    private DatasafeFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class WithCredentialProvider
    extends BucketAccessServiceImpl {
        private final RegexAccessServiceWithStorageCredentialsImpl delegate;

        private WithCredentialProvider(Lazy<StorageKeyStoreOperations> storageKeyStoreOperations) {
            super(null);
            this.delegate = new RegexAccessServiceWithStorageCredentialsImpl(storageKeyStoreOperations);
        }

        @Generated
        public AbsoluteLocation<PrivateResource> privateAccessFor(UserIDAuth user, PrivateResource resource) {
            return this.delegate.privateAccessFor(user, resource);
        }

        @Generated
        public AbsoluteLocation<PublicResource> publicAccessFor(UserID user, PublicResource resource) {
            return this.delegate.publicAccessFor(user, resource);
        }

        @Generated
        public AbsoluteLocation withSystemAccess(AbsoluteLocation resource) {
            return this.delegate.withSystemAccess(resource);
        }
    }
}

