/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.cli;

import com.google.gson.Gson;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.cli.commands.Help;
import de.adorsys.datasafe.cli.commands.inbox.Inbox;
import de.adorsys.datasafe.cli.commands.privatespace.Privatespace;
import de.adorsys.datasafe.cli.commands.profile.Profile;
import de.adorsys.datasafe.cli.config.DatasafeFactory;
import de.adorsys.datasafe.cli.dto.Credentials;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import lombok.Generated;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="datasafe-cli", subcommands={Help.class, Profile.class, Privatespace.class, Inbox.class})
public class Cli
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Cli.class);
    @CommandLine.Option(names={"--root-dir", "-rd"}, description={"Folder with user profiles, default is current directory"})
    private Path profilesRoot = Paths.get("", new String[0]);
    @CommandLine.ArgGroup(multiplicity="1")
    private CredentialsExclusive credentials;

    public static void main(String[] args) {
        Cli.reInitializeRandomAgain();
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        int exitCode = new CommandLine((Object)new Cli()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public void run() {
        CommandLine.usage((Object)new Cli(), (PrintStream)System.out);
    }

    public DefaultDatasafeServices datasafe() {
        return DatasafeFactory.datasafe(this.profilesRoot, this.credentials.getSystemPassword());
    }

    public UserIDAuth auth() {
        return new UserIDAuth(this.credentials.getUsername(), this.credentials.getPassword());
    }

    private static void reInitializeRandomAgain() {
        Field secureRandom = CryptoServicesRegistrar.class.getDeclaredField("defaultSecureRandom");
        secureRandom.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(secureRandom, secureRandom.getModifiers() & 0xFFFFFFEF);
        secureRandom.set(CryptoServicesRegistrar.class, null);
    }

    @Generated
    public Cli() {
    }

    @Generated
    public Path getProfilesRoot() {
        return this.profilesRoot;
    }

    private static class CredentialsExclusive {
        @CommandLine.Option(names={"--credentials", "-c"}, description={"File with credentials location. It contains JSON: {\"username\": \"<username>\", \"password\": \"<password>\", \"systemPassword\": \"<systemPassword>\"}"})
        private Path credentialsFile;
        @CommandLine.ArgGroup(exclusive=false)
        private Credentials credentials;

        private CredentialsExclusive() {
        }

        String getUsername() {
            return this.credentials().getUsername();
        }

        ReadKeyPassword getPassword() {
            return new ReadKeyPassword((Supplier)new Supplier<char[]>(){

                @Override
                public char[] get() {
                    return this.credentials().getPassword().toCharArray();
                }
            });
        }

        ReadStorePassword getSystemPassword() {
            return new ReadStorePassword(this.credentials().getSystemPassword());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Credentials credentials() {
            if (null != this.credentials) {
                return this.credentials;
            }
            try (BufferedReader is = Files.newBufferedReader(this.credentialsFile);){
                Credentials credentials = (Credentials)new Gson().fromJson((Reader)is, Credentials.class);
                return credentials;
            }
        }
    }
}

