/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.storage.api.SchemeDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.db.DatabaseConnectionRegistry;
import de.adorsys.datasafe.storage.impl.db.DatabaseCredentials;
import de.adorsys.datasafe.storage.impl.db.DatabaseStorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.global.PathEncryptionId;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.datasafe.types.api.utils.ReadKeyPasswordTestFactory;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SchemeDelegationWithDbTest
extends WithStorageProvider {
    private static final Set<String> ALLOWED_TABLES = ImmutableSet.of((Object)"users", (Object)"private_profiles", (Object)"public_profiles");
    private Path fsPath;
    private StorageService db;
    private DefaultDatasafeServices datasafeServices;

    SchemeDelegationWithDbTest() {
    }

    @BeforeEach
    void initialize(@TempDir Path tempDir) {
        this.fsPath = tempDir;
        FileSystemStorageService filesystem = new FileSystemStorageService(tempDir);
        this.db = new DatabaseStorageService(ALLOWED_TABLES, new DatabaseConnectionRegistry(uri -> uri.location().getWrapped().getScheme() + ":" + uri.location().getPath().split("/")[1], (Map)ImmutableMap.of((Object)"jdbc://localhost:9999", (Object)new DatabaseCredentials("sa", "sa"))));
        SchemeDelegatingStorage multiDfs = new SchemeDelegatingStorage((Map)ImmutableMap.of((Object)"file", (Object)filesystem, (Object)"jdbc", (Object)this.db));
        this.datasafeServices = DaggerDefaultDatasafeServices.builder().config((DFSConfig)new ProfilesOnDbDataOnFs(tempDir.toUri(), URI.create("jdbc://localhost:9999/h2:mem:test/"))).storage((StorageService)multiDfs).build();
    }

    @Test
    void testProfileOnDbDataOnFsWorks() {
        UserIDAuth userJohn = new UserIDAuth("john", ReadKeyPasswordTestFactory.getForString((String)"doe"));
        this.datasafeServices.userProfile().registerUsingDefaults(userJohn);
        try (PasswordClearingOutputStream os = this.datasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)userJohn, (String)"file.txt"));){
            os.write("Hello".getBytes());
        }
        Assertions.assertThat(this.listDb("jdbc://localhost:9999/h2:mem:test/private_profiles/")).containsExactly((Object[])new String[]{"jdbc://localhost:9999/h2:mem:test/private_profiles/john"});
        Assertions.assertThat(this.listDb("jdbc://localhost:9999/h2:mem:test/public_profiles/")).containsExactly((Object[])new String[]{"jdbc://localhost:9999/h2:mem:test/public_profiles/john"});
        Path path = this.fsPath.resolve(new Uri("users/john/private/files/").resolve(PathEncryptionId.AES_SIV.asUriRoot()).asString());
        Path encryptedFile = this.walk(path).get(1);
        Assertions.assertThat(this.walk(this.fsPath)).extracting(it -> this.fsPath.toUri().relativize(it.toUri())).extracting(URI::toString).containsExactlyInAnyOrder((Object[])new String[]{"", "users/", "users/john/", "users/john/public/", "users/john/public/pubkeys", "users/john/private/", "users/john/private/keystore", "users/john/private/files/", "users/john/private/files/SIV/", this.fsPath.toUri().relativize(encryptedFile.toUri()).toString()});
    }

    private List<Path> walk(Path at) {
        List<Path> list;
        block8: {
            Stream<Path> ls = Files.walk(at, new FileVisitOption[0]);
            try {
                list = ls.collect(Collectors.toList());
                if (ls == null) break block8;
            }
            catch (Throwable throwable) {
                if (ls != null) {
                    try {
                        ls.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            ls.close();
        }
        return list;
    }

    private List<String> listDb(String path) {
        try (Stream stream = this.db.list(BasePrivateResource.forAbsolutePrivate((URI)URI.create(path)));){
            List<String> list = stream.map(it -> it.location().asURI().toString()).collect(Collectors.toList());
            return list;
        }
    }

    static class ProfilesOnDbDataOnFs
    extends DefaultDFSConfig {
        private final Uri profilesPath;

        ProfilesOnDbDataOnFs(URI fsPath, URI profilesPath) {
            super(fsPath, new ReadStorePassword("PAZZWORT"));
            this.profilesPath = new Uri(profilesPath);
        }

        public AbsoluteLocation publicProfile(UserID forUser) {
            return new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.profilesPath.resolve("public_profiles/").resolve(forUser.getValue())));
        }

        public AbsoluteLocation privateProfile(UserID forUser) {
            return new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.profilesPath.resolve("private_profiles/").resolve(forUser.getValue())));
        }
    }
}

