/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.encryption.EncryptionConfig;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.datasafe.types.api.utils.ReadKeyPasswordTestFactory;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import java.io.InputStream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.apache.commons.lang3.time.StopWatch;

public class KeyStoreTypeCompareTest
extends BaseE2ETest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyStoreTypeCompareTest.class);
    private static final int NUMBER_WRITES = 100;
    private static final int NUMBER_READS = 100;

    @ParameterizedTest
    @MethodSource(value={"fsOnly"})
    void compareKeyStoreTypes(WithStorageProvider.StorageDescriptor descriptor) {
        long tUBER = this.test(descriptor, "johnUber", "UBER");
        long tBCFKS = this.test(descriptor, "johnBCFKS", "BCFKS");
        log.info("UBER  test took: {}", (Object)tUBER);
        log.info("BCFKS test took: {}", (Object)tBCFKS);
        org.junit.jupiter.api.Assertions.assertTrue((tUBER * 3L > tBCFKS ? 1 : 0) != 0);
    }

    long test(WithStorageProvider.StorageDescriptor descriptor, String userName, String keystoreType) {
        int i;
        this.init(descriptor, keystoreType);
        UserID user = new UserID(userName);
        Assertions.assertThat((boolean)this.profileRetrievalService.userExists(user)).isFalse();
        this.john = this.registerUser(user.getValue(), ReadKeyPasswordTestFactory.getForString((String)"john"));
        Assertions.assertThat((boolean)this.profileRetrievalService.userExists(user)).isTrue();
        String filename = "root.txt";
        String content = "affe";
        StopWatch timer = new StopWatch();
        timer.start();
        for (i = 0; i < 100; ++i) {
            log.debug("write file for the {} time", (Object)i);
            try (PasswordClearingOutputStream os = this.writeToPrivate.write(WriteRequest.forDefaultPrivate((Object)this.john, (String)filename));){
                os.write(content.getBytes());
                continue;
            }
        }
        for (i = 0; i < 100; ++i) {
            log.debug("read file for the {} time", (Object)i);
            try (PasswordClearingInputStream is = this.readFromPrivate.read(ReadRequest.forDefaultPrivate((Object)this.john, (String)filename));){
                Assertions.assertThat((InputStream)is).hasContent(content);
                continue;
            }
        }
        timer.stop();
        long diff = timer.getTime();
        log.info("TIME TOOK {} MILLISECS", (Object)diff);
        return diff;
    }

    private void init(WithStorageProvider.StorageDescriptor descriptor, String keystoreType) {
        DefaultDatasafeServices datasafeServices = DaggerDefaultDatasafeServices.builder().config((DFSConfig)new DefaultDFSConfig(descriptor.getLocation(), new ReadStorePassword("PAZZWORT"))).encryption(EncryptionConfig.builder().keystore(KeyStoreConfig.builder().type(keystoreType).build()).build()).storage((StorageService)descriptor.getStorageService().get()).build();
        this.initialize(DatasafeServicesProvider.dfsConfig(descriptor.getLocation()), datasafeServices);
    }
}

