/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingStream;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.AEADBadTagException;
import lombok.Generated;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Java6Assertions;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.cryptomator.siv.UnauthenticCiphertextException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.collect.ImmutableSet;
import org.testcontainers.shaded.com.google.common.io.ByteStreams;

class DataTamperingResistanceTest
extends BaseE2ETest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataTamperingResistanceTest.class);
    private static final Set<Character> NOT_TO_REPLACE_IN_PATH = ImmutableSet.of((Object)Character.valueOf('='), (Object)Character.valueOf('/'));
    private static final String FILE_TEXT = "Tampering test!!Tampering test!!Tampering test!!Tampering test!!Tampering test!!";
    private static final String FILENAME = "my_file_with_quite_a__long_na.me_na.me_na.me_na.me_na.me_na.me_na.me_na.me";
    private static final String DIR_AND_FILENAME = "my_directory_with_quite_a__long_na.me_na.me_na.me_na.me_na.me_na.me_na.me_na.me/my_file";
    private static final String DIR_DIR_AND_FILENAME = "my_directory_with_quite_a__long_na.me_na.me_na.me_na.me_na.me_na.me_na.me_na.me/deeper/my_file";

    DataTamperingResistanceTest() {
    }

    @BeforeEach
    void prepare() {
        this.init();
        this.registerJohnAndJane();
    }

    @Test
    void testPrivateDocumentContentTamperResistance() {
        try (PasswordClearingOutputStream os = this.writeToPrivate.write(WriteRequest.forDefaultPrivate((Object)this.jane, (String)FILENAME));){
            os.write(FILE_TEXT.getBytes(StandardCharsets.UTF_8));
        }
        AbsoluteLocation<ResolvedResource> privateFile = this.getFirstFileInPrivate(this.jane);
        this.tamperFileByReplacingOneByteOfEncryptedMessage(privateFile);
        try (PasswordClearingInputStream is = this.readFromPrivate.read(ReadRequest.forDefaultPrivate((Object)this.jane, (String)FILENAME));){
            ((AbstractThrowableAssert)Java6Assertions.assertThatThrownBy(() -> DataTamperingResistanceTest.lambda$testPrivateDocumentContentTamperResistance$0((InputStream)is)).isInstanceOf(InvalidCipherTextIOException.class)).hasCauseInstanceOf(AEADBadTagException.class);
        }
    }

    @Test
    void testInboxDocumentContentTamperResistance() {
        try (OutputStream os = this.writeToInbox.write(WriteRequest.forDefaultPublic(Collections.singleton(this.john.getUserID()), (String)FILENAME));){
            os.write(FILE_TEXT.getBytes(StandardCharsets.UTF_8));
        }
        AbsoluteLocation<ResolvedResource> inboxFile = this.getFirstFileInInbox(this.john);
        this.tamperFileByReplacingOneByteOfEncryptedMessage(inboxFile);
        try (InputStream is = this.readFromInbox.read(ReadRequest.forDefaultPrivate((Object)this.john, (String)FILENAME));){
            ((AbstractThrowableAssert)Java6Assertions.assertThatThrownBy(() -> ByteStreams.copy((InputStream)is, (OutputStream)ByteStreams.nullOutputStream())).isInstanceOf(InvalidCipherTextIOException.class)).hasCauseInstanceOf(AEADBadTagException.class);
        }
    }

    @ParameterizedTest(name="{arguments}")
    @ValueSource(strings={"my_file_with_quite_a__long_na.me_na.me_na.me_na.me_na.me_na.me_na.me_na.me", "my_directory_with_quite_a__long_na.me_na.me_na.me_na.me_na.me_na.me_na.me_na.me/my_file", "my_directory_with_quite_a__long_na.me_na.me_na.me_na.me_na.me_na.me_na.me_na.me/deeper/my_file"})
    void testPrivateDocumentPathTamperResistance(String path) {
        try (PasswordClearingOutputStream os = this.writeToPrivate.write(WriteRequest.forDefaultPrivate((Object)this.jane, (String)path));){
            os.write(FILE_TEXT.getBytes(StandardCharsets.UTF_8));
        }
        AbsoluteLocation<ResolvedResource> privateFile = this.getFirstFileInPrivate(this.jane);
        this.tamperFilenameByReplacingOneCharOfPath(privateFile, path);
        Assertions.assertThrows(UnauthenticCiphertextException.class, () -> {
            try (PasswordClearingStream lsPrivate = this.listPrivate.list(ListRequest.forDefaultPrivate((Object)this.jane, (String)""));){
                lsPrivate.forEach(it -> log.info("{}", (Object)it.location()));
            }
        });
    }

    private void init() {
        WithStorageProvider.StorageDescriptor descriptor = DataTamperingResistanceTest.fs();
        DefaultDatasafeServices datasafeServices = DatasafeServicesProvider.defaultDatasafeServices((StorageService)descriptor.getStorageService().get(), descriptor.getLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(descriptor.getLocation()), datasafeServices);
    }

    private void tamperFilenameByReplacingOneCharOfPath(AbsoluteLocation<ResolvedResource> privateFile, String origPath) {
        Path physicalFile = Paths.get(((ResolvedResource)privateFile.getResource()).location().asURI());
        byte[] privateBytes = Files.readAllBytes(physicalFile);
        Object pathAsString = physicalFile.toAbsolutePath().toString();
        int characterToTamper = ((String)pathAsString).length() - origPath.length() / 2;
        while (NOT_TO_REPLACE_IN_PATH.contains(Character.valueOf(((String)pathAsString).charAt(characterToTamper)))) {
            --characterToTamper;
        }
        log.info("About to tamper path `{}`", pathAsString);
        pathAsString = ((String)pathAsString).substring(0, characterToTamper - 1) + this.randomChar(((String)pathAsString).charAt(characterToTamper)) + ((String)pathAsString).substring(characterToTamper);
        log.info("Tampered path as `{}`", pathAsString);
        Files.createDirectories(Paths.get((String)pathAsString, new String[0]).getParent(), new FileAttribute[0]);
        Files.write(Paths.get((String)pathAsString, new String[0]), privateBytes, StandardOpenOption.CREATE);
    }

    private void tamperFileByReplacingOneByteOfEncryptedMessage(AbsoluteLocation<ResolvedResource> privateFile) {
        Path physicalFile = Paths.get(((ResolvedResource)privateFile.getResource()).location().asURI());
        byte[] privateBytes = Files.readAllBytes(physicalFile);
        int somewhereInEncText = privateBytes.length - FILE_TEXT.length() / 2;
        privateBytes[somewhereInEncText] = this.randomByte(privateBytes[somewhereInEncText]);
        Files.write(physicalFile, privateBytes, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private char randomChar(char notEqualTo) {
        char result;
        while ((result = (char)(ThreadLocalRandom.current().nextInt(26) + 97)) == notEqualTo) {
        }
        return result;
    }

    private byte randomByte(byte notEqualTo) {
        byte[] resultArray = new byte[1];
        do {
            ThreadLocalRandom.current().nextBytes(resultArray);
        } while (notEqualTo == resultArray[0]);
        return resultArray[0];
    }

    private static /* synthetic */ void lambda$testPrivateDocumentContentTamperResistance$0(InputStream is) throws Throwable {
        ByteStreams.copy((InputStream)is, (OutputStream)ByteStreams.nullOutputStream());
    }
}

